/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xY1x
 */

package {
    import flash.display.Sprite;
	import flash.events.Event;
    public class FlashTest extends Sprite {
        public function FlashTest() {
			_array = new Array();
			this.addEventListener(Event.ENTER_FRAME, proc);
        }
		
		private function create():Shape
		{
			var shape:Shape = new Shape();
			this.addChild( shape );
			return shape;
		}

		private function proc(e:Event):void
		{
			++_interval;
			if ( _interval >= 5 )
			{
				if ( _array.length < 20 )
				{
					_array.push( create() );
				}
				_interval = 0;
			}
			
			for ( var i:int = 0; i < _array.length; ++i )
			{
				_array[ i ].update();
				
				if ( _array[ i ].isDead )
				{
					this.removeChild( _array[ i ] );
					_array[ i ] = create();
				}
			}

            this.graphics.clear();
			for ( var i:int = 0; i < _array.length; ++i )
			{
				_array[ i ].draw( this.graphics );
			}			
		}
		
		private var _array:/*Shape*/Array;
		private var _interval:uint;
    }
}

import flash.display.Graphics;
import flash.display.Sprite;
import flash.geom.Point;

class Shape extends Sprite
{
	public function Shape()
	{
		_log = new Array();
		_radius = ( Math.random() * 200 ) + 50;
		_angle = Math.random() * Math.PI * 2;

		var colorTable:/*uint*/Array = new Array();
		colorTable.push( 0xffbbbb, 0x99ff99, 0xbbbbff, 0xffdd88, 0xff66ff, 0x88ddff );
		_color = colorTable[ int( Math.random() * colorTable.length ) ];
		_alpha = 0;
		_lifespan = 100;
		_isDead = false;
	}
	
	public function get isDead():Boolean
	{
		return _isDead;
	}
	
	public function update():void
	{
		if ( _isDead )
		{
			return;
		}
		
		_angle += 4.0 / _radius;
		
		var pos:Point = new Point();
		pos.x = Math.cos(_angle) * _radius;
		pos.y = Math.sin(_angle) * _radius;
		_log.push(pos);
		if (_log.length > 24)
		{
			_log.splice(0, 1);
		}

		--_lifespan;
		if ( _lifespan == 0 )
		{
			_isDead = true;
		}
		
		if ( _lifespan < 10 )
		{
			_alpha = _lifespan * 0.1 ;
		}
		else if ( _lifespan > 60 )
		{
			_alpha = 1.0 - ( ( _lifespan - 60 ) * 0.025 );
		}
		else
		{
			_alpha = 1.0;
		}
	}
	
	public function draw( g:Graphics ):void
	{
		if ( _isDead )
		{
			return;
		}

		for ( var i:int = 0; i < _log.length; ++i )
		{
       		g.beginFill( _color, _alpha );
			var pos:Point = _log[ _log.length - 1 - i ];
			g.drawCircle( 232.5 + pos.x, 232.5 + pos.y, 5 - ( 0.1 * i ) );
        	g.endFill();
		}
	}
	
	private var _log:/*Point*/Array;
	private var _radius:Number;
	private var _angle:Number;
    private var _color:uint;
    private var _alpha:Number;
	private var _lifespan:uint;
	private var _isDead:Boolean;
}