/**
 * Copyright Thy ( http://wonderfl.net/user/Thy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xX1Y
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;

	
	/**
	 * ...
	 * @author Thi
	 */
	public class Circular extends Sprite 
	{
		
		public function Circular():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			variaveis()
		}
		
		
		
		private var precision:Number = 2
		
		
		private var particulas:Vector.<particula> = new Vector.<particula>()
		private var partShapes:Vector.<Shape> = new Vector.<Shape>()
		private function variaveis():void
		{
			
			stage.addChild(B)
			stage.addChild(S)
			
			stage.frameRate = 40
			stage.addEventListener(Event.ENTER_FRAME, ef)
			
			initText()
			
		}
		
		// k 1 PI / 1  +-  1 PI / 1
		private var v0:Number = 1 //  *PI
		private var v1:Number = 1 //  PI/
		private var v2:Number = 1 //   +  -  +-
		private var v3:Number = 1 //  *PI
		private var v4:Number = 3 //  PI/
		
		private var T0:TextField = new TextField()
		private var T1:TextField = new TextField()
		private var T2:TextField = new TextField()
		private var T3:TextField = new TextField()
		private var T4:TextField = new TextField()
		
		private var t:TextField = new TextField()
		private var t0:TextField = new TextField()
		private var t1:TextField = new TextField()
		private var t2:TextField = new TextField()
		private var t3:TextField = new TextField()
		
		private var V0:Number = v0 * 180 / v1
		private var V1:Number = v3 * 180 / v4
		
		private function initText():void
		{
			T0.autoSize = TextFieldAutoSize.LEFT
			T1.autoSize = TextFieldAutoSize.LEFT
			T2.autoSize = TextFieldAutoSize.LEFT
			T3.autoSize = TextFieldAutoSize.LEFT
			T4.autoSize = TextFieldAutoSize.LEFT
			t.autoSize = TextFieldAutoSize.LEFT
			t0.autoSize = TextFieldAutoSize.LEFT
			t1.autoSize = TextFieldAutoSize.LEFT
			t2.autoSize = TextFieldAutoSize.LEFT
			t3.autoSize = TextFieldAutoSize.LEFT
			
			T0.type = "input"
			T1.type = "input"
			T2.type = "input"
			T3.type = "input"
			T4.type = "input"
			
			t.type = "dynamic"
			t0.type = "dynamic"
			t1.type = "dynamic"
			t2.type = "dynamic"
			t3.type = "dynamic"
			
			t.selectable = false
			t0.selectable = false
			t1.selectable = false
			t2.selectable = false
			t3.selectable = false
			
			T0.text = String(v0)
			T1.text = String(v1)
			T2.text = "-"
			T3.text = String(v3)
			T4.text = String(v4)
			
			t.text = "k . "
			t0.text = "/"
			t1.text = " . π"
			t2.text = "/"
			t3.text = " . π"
			
			
			t.x = 20
			T0.x = t.x + t.width
			t0.x = T0.x + T0.width
			T1.x = t0.width + t0.x
			t1.x = T1.x + T1.width
			T2.x = t1.x + t1.width + 20
			T3.x = T2.x + T2.width + 20
			t2.x = T3.x + T3.width
			T4.x = t2.x + t2.width
			t3.x = T4.x + T4.width
			//T.text = v0 + "/" + v1 + " * π" + " " + v2 + " " + v3 + "/" + v4 + " * π"
			t.textColor = 0xFFFFFF
			t0.textColor = 0xFFFFFF
			t1.textColor = 0xFFFFFF
			t2.textColor = 0xFFFFFF
			t3.textColor = 0xFFFFFF
			
			T0.textColor = 0xFFFFFF
			T1.textColor = 0xFFFFFF
			T2.textColor = 0xFFFFFF
			T3.textColor = 0xFFFFFF
			T4.textColor = 0xFFFFFF
			
			stage.addChild(t)
			stage.addChild(t0)
			stage.addChild(t1)
			stage.addChild(t2)
			stage.addChild(t3)
			
			stage.addChild(T0)
			stage.addChild(T1)
			stage.addChild(T2)
			stage.addChild(T3)
			stage.addChild(T4)
		}
		
		private var a:Number = 0
		private var cx:Number = stage.stageWidth * .5
		private var cy:Number = stage.stageHeight * .5
		private var r:Number = 100
		
		private var rad:Number = Math.PI/180
		
		private var S:Shape = new Shape()
		private var G:Graphics = S.graphics
		private var gx0:Number = 0, gy0:Number = 0, gx1:Number = cx, gy1:Number = cy
		
		private var temp:particula
		private var tempS:Shape
		private var tempG:Graphics
		private var cor:uint = 0
		
		private function ef(e:Event = null):void
		{	
			texts()
			couter()
			part()
			filtros()
		}
		
		
		private function couter():void
		{
			
			gx1 = gx0
			gy1 = gy0
			
			gx0 = cx + Math.cos(rad * a) * r
			gy0 = cy + Math.sin(rad * a) * r
			
			G.clear()
			with (G)
			{
				lineStyle(2,0xFFFFFF)
				moveTo(gx1, gy1)
			}
			
			
			if (a % V0 == 0)
			{
				
				tempS = new Shape()
				tempG = tempS.graphics
				cor = 0xFF0000 // uint((Math.random()*0xFF) << 16 | (Math.random()*0xFF) << 8 | Math.random()*0xFF)
				tempG.lineStyle(2, cor)
				tempG.drawCircle(0, 0, 3)
				stage.addChild(tempS)
				
				G.lineStyle(4,0xFFFFFF)
				
				switch(v2)
				{
					case 0:
					particulas.push(new particula(gx0, gy0, a, a - V1))
					partShapes.push(tempS)
					break;
					case 1:
					particulas.push(new particula(gx0, gy0, a, a + V1))
					partShapes.push(tempS)
					break;
					default:
					particulas.push(new particula(gx0, gy0, a, a - V1))
					particulas.push(new particula(gx0, gy0, a, a + V1))
					partShapes.push(tempS)
					
					tempS = new Shape()
					tempG = tempS.graphics
					cor = 0xFF0000 // uint((Math.random()*0xFF) << 16 | (Math.random()*0xFF) << 8 | Math.random()*0xFF)
					tempG.lineStyle(2, cor)
					tempG.drawCircle(0, 0, 3)
					stage.addChild(tempS)
					partShapes.push(tempS)
				}
				trace("uia", a, V0, V1)
			}
			
			
			
			with (G)
			{
				lineTo(gx0, gy0)
			}
			
			a -= precision
		}
		
		private var i:int
		private var l:int
		private var matrix:Matrix
		
		private function part():void
		{
			l = particulas.length
			i = 0
			while (i < l)
			{
				temp = particulas[i]
				
				temp.a0 += (temp.a1 - temp.a0) * .1
				
				temp.x = cx + Math.cos(rad * temp.a0) * r
				temp.y = cy + Math.sin(rad * temp.a0) * r
				
				tempS = partShapes[i]
				tempS.x = temp.x
				tempS.y = temp.y
				//D.setPixel(temp.x, temp.y, 0xFF0000)
				
				if (Math.round(temp.a0) == Math.round(temp.a1))
				{
					matrix = new Matrix()
					matrix.tx = temp.x
					matrix.ty = temp.y
					D.draw(tempS, matrix)
					matrix = null
					
					particulas[i] = null
					particulas.splice(i, 1)
					stage.removeChild(tempS)
					tempS = null
					partShapes.splice(i, 1)
					
					--i
					--l
				}
				
				++i
			}
			
		}
		
		private var D:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFFFFFF)
		private var B:Bitmap = new Bitmap(D, "auto", true)
		private var rect:Rectangle = D.rect
		private var p:Point = new Point(0,0)
		
		private var col:ColorTransform = new ColorTransform(.9, .99, .99)
		private var blur:BlurFilter = new BlurFilter(2, 2, 1)
		
		private function filtros():void
		{
			
			D.draw(S)
			D.colorTransform(rect, col)
			//D.applyFilter(D, rect, p, blur)
		}
		
		
		private var i0:Number, i1:Number, i2:String, i3:Number, i4:Number
		private var mudou:Boolean
		
		private function texts():void
		{
			mudou = false
				
				
			if (Number(T0.text) != i0)
			{
				mudou = true
				i0 = v0 =  Number(T0.text)
			} 
			
			if (Number(T1.text) != i1)
			{
				mudou = true
				i1 = v1 =  Number(T1.text)
			} 
			
			if (Number(T3.text) != i3)
			{
				mudou = true
				i3 = v3 = Number(T3.text)
			}  
				
			if (Number(T4.text) != i4)
			{
				mudou = true
				i4 = v4 = Number(T4.text)
			} 
			
			
			i2 = T2.text 
			
			
			if (i2 == "+" && v2 != 0)
			{
				mudou = true
				v2 = 0
			} else if (i2 == "-" && v2 != 1)
			{
				mudou = true
				v2 = 1
			} else  if (i2 == "+-" && v2 != 2)
			{
				mudou = true
				v2 = 2
			}
			
			
			if (mudou)
			{
				a = 0
				V0 = v0 * 180 / v1
				V1 = v3 * 180 / v4
				t.x = 20
				
				T0.x = t.x + t.width
				t0.x = T0.x + T0.width
				T1.x = t0.width + t0.x
				t1.x = T1.x + T1.width
				T2.x = t1.x + t1.width + 20
				T3.x = T2.x + T2.width + 20
				t2.x = T3.x + T3.width
				T4.x = t2.x + t2.width
				t3.x = T4.x + T4.width
			}
			
			
			
			
			
			
			
			
			
		}
		
	}
	
}



class particula 
	{
		
		public var x:Number, y:Number, a0:Number, a1:Number
		
		public function particula(x:Number, y:Number, a0:Number, a1:Number):void
		{
			this.x = x
			this.y = y
			this.a0 = a0
			this.a1 = a1
		}
		
		
		
	}