/**
 * Copyright xor ( http://wonderfl.net/user/xor )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xWcC
 */

// forked from Kay's Metaric Button Surface
package {
    import flash.display.Sprite;
    import flash.events.Event;
    public class FlashTest extends Sprite {
     public function FlashTest():void{
            addEventListener(Event.ADDED_TO_STAGE, init);
            if(null != stage) init();
        }

        private function init(e:Event = null):void {
            // default:
            var face1:Surface = new Surface();
            face1.x = (stage.stageWidth - face1.width)/2;
            face1.y = 20;
            addChild(face1);
            
            // custom:
            var face2:Surface = new Surface(0,0,200,50, 20, 0x990033);
            face2.x = (stage.stageWidth - face2.width)/2;
            face2.y = face1.y + face1.height + 20;
            addChild(face2);
            
            // random 1:
            var width:Number = Math.random()*300+100;
            var height:Number = Math.random()*50+50;
            var corner:Number = height;
            var color:int = Math.ceil(Math.random()*0xffffff);
            var face3:Surface = new Surface(0,0,width, height, corner, color);
            face3.x = (stage.stageWidth - face3.width)/2;
            face3.y = face2.y + face2.height + 20;
            addChild(face3);

            // random 2:
            width = Math.random()*300+100;
            height = Math.random()*50+50;
            corner = Math.random()*height/2 + 20;
            color = Math.ceil(Math.random()*0xffffff);
            var face4:Surface = new Surface(0,0,width, height, corner, color);
            face4.x = (stage.stageWidth - face4.width)/2;
            face4.y = face3.y + face3.height + 20;
            addChild(face4);
        }
    }
}
    import flash.display.Shape;
    import flash.display.GradientType;
    import flash.geom.Matrix;
    class Surface extends Shape {
        public function Surface(nX:Number=0, nY:Number=0, nWidth:Number=100, nHeight:Number=20, nCorner:Number=5, nColor:int=0xcccccc):void {
            var baseColor:int = nColor;
            // baseColor->HLS;
            var HLS:Object = ColorUtil.getHLS(baseColor);
            // getDarkColor
            var darkRGB:Object = ColorUtil.HLS2RGB(HLS.h, HLS.l/2, HLS.s);
            var darkColor:int = darkRGB.r<<16 | darkRGB.g<<8 | darkRGB.b;
            // getBrightColor
            var brightRGB:Object = ColorUtil.HLS2RGB(HLS.h, 100-HLS.l/2, HLS.s);
            var brightColor:int = brightRGB.r<<16 | brightRGB.g<<8 | brightRGB.b;
            // setGradation
            var gType:String = GradientType.LINEAR;
            var gColor:Array = [baseColor,darkColor,brightColor,baseColor];
            var gAlpha:Array = [1,1,1,1];
            var gRatio:Array = [0,0x44,0x50,0xff];
            var gMatrix:Matrix = new Matrix();
            // outline
            graphics.beginFill(darkColor);
            graphics.drawRoundRect(nX,nY,nWidth,nHeight,nCorner);
            graphics.endFill();
            // outer
            gMatrix.createGradientBox(nWidth-1,nHeight-1,Math.PI/2,nX+0.5,nY+0.5);
            graphics.beginGradientFill(gType,gColor,gAlpha,gRatio,gMatrix);
            graphics.drawRoundRect(nX+0.5,nY+0.5,nWidth-1,nHeight-1,nCorner-0.5);
            graphics.endFill();
            // face
            gColor = [baseColor,brightColor,darkColor,baseColor];
            gMatrix.createGradientBox(nWidth-4,nHeight-4,Math.PI/2,nX+2,nY+2);            graphics.beginGradientFill(gType,gColor,gAlpha,gRatio,gMatrix);
            graphics.drawRoundRect(nX+2,nY+2,nWidth-4,nHeight-4,nCorner-2);
            graphics.endFill();
        }
    }
    
    /*
     * sketchBook.colors.ColorUtil;
     */
    class ColorUtil{
        
    public function ColorUtil(){
        throw new Error("ColorUtil is static class");
    }
    
    
    
    /**
     * 24ビットの色を、h,s,bを格納したオブジェクトに変換します。
     * @param 24bit color.
     * @returns HSB object {h:Hue, s:Saturation, b:Brightness}
    */
    public static function getHSB(color:int):Object
    {
        var rgbObj:Object = getRGB(color);
        return RGB2HSB(rgbObj.r,rgbObj.g,rgbObj.b);
    }
    
    
    /**
     * 24ビットの色を、h,l,sを格納したオブジェクトに変換します。
     * @param 24bit color
     * @returns HLS object {h:Hue, l:Luminous, s:Saturation}
     */
    public static function getHLS(color:int):Object{
        var rgbObj:Object = getRGB(color);
        return RGB2HLS(rgbObj.r, rgbObj.g, rgbObj.b)
    }
    
    
    /**
     * 24ビットの色を、r,g,bを格納したオブジェクトに変換します。
     * 
     * @param 24bit color
     * @return Object that contains {r:Red, g:Green, b:Blue}
     */
    public static function getRGB(rgb:int):Object{
        return { 
                    r: rgb >> 16 & 0xff,
                    g: rgb >> 8 & 0xff,
                    b: rgb & 0xff
                    }
    }
    
    
    
    /**
     * r,g,bを格納したオブジェクトの色を、HSBで定義しなおします。
     * 
     * @param Object with property h, s, b
     * @param hue 0-255
     * @param saturation 0-255
     * @param brightness 0-255
     */
    public static function setHSB( col:Object, h:Number, s:Number, b:Number):void
    {
        var rgbObj:Object = HSB2RGB(h,s,b);
        setRGB(col, rgbObj.r, rgbObj.g, rgbObj.b);
    }
    
    
    
    /**
     * r,g,bを格納したオブジェクトの色を、HLSで定義しなおします。
     * 
     * @param Object with property h, s, b
     * @param hue 0-255
     * @param luminus 0-255
     * @param saturation 0-255
     */
    public static function setHLS( col:Object, h:Number, l:Number, s:Number):void{
        var rgbObj:Object = HLS2RGB(h,l,s);
        setRGB(col, rgbObj.r, rgbObj.g, rgbObj.b);
    }
    
    
    /**
     * Set Color.value with R,G,B.
     * 
     * @param Object with property r, g, b
     * @param red 0-255
     * @param green 0-255
     * @param blue 0-255
     */
    public static function setRGB(obj:Object, r:int, g:int, b:int):void{
        r = (r < 0)? 0 : (r>255)? 255: Math.round(r);
        g = (g < 0)? 0 : (g>255)? 255: Math.round(g);
        b = (b < 0)? 0 : (b>255)? 255: Math.round(b);
        obj.r = r<<16
        obj.g = g<<8
        obj.b = b
    }
    
    

    /**
     * Create {h,s,b} Object from H, L, S value.
     * 
     * @param hue
     * @param luminous
     * @param saturation
     * @return {h:Hue, s:Saturation, b:Brightness}
     */
    public static function HLS2HSB(h:Number, l:Number, s:Number):Object{
        var rgbObj:Object = HLS2RGB(h,l,s);
        return RGB2HSB(rgbObj.r, rgbObj.g, rgbObj.b);
    }
    
    
    
    /**
     * H, L, Sの値から、{r,g,b}のオブジェクトを取得します。
     * 
     * @param hue
     * @param luminous
     * @param saturation
     * @return {r:Red, g:Green, b:Blue}
     */
    public static function HLS2RGB(h:Number, l:Number, s:Number):Object{
        var max:Number, min:Number;
        
        h = (h<0)? h % 360+360 : (h>=360)? h%360: h;
        l = (l<0)? 0 : (l>100)? 100: l;
        s = (s<0)? 0 : (s>100)? 100: s;
        
        l *= 0.01;
        s *= 0.01;
        
        if(s==0){
            var val:Number = l * 255;
            return {r:val, g:val, b:val};
        }
        
        if( l < 0.5){
            max = l * (1+s) * 255
        }else{
            max = (l * (1-s) + s)*255
        }
        min = (2 * l)*255 - max;
        
        return _hMinMax2RGB(h, min, max);    //HSBとHLSの共通部分
    }
    
    
    
    /**
     * Converts H, S, B values to {h:Hue, l:Luminous, s:Saturation} Object
     * 
     * @param hue
     * @param saturation
     * @param brightness
     * @return {h:Hue, l:Luminous, s:Saturation}
     */
    public static function HSB2HLS(h:Number, s:Number, b:Number):Object{
        var rgbObj:Object = HSB2RGB(h,s,b);
        return RGB2HLS(rgbObj.r, rgbObj.g, rgbObj.b);
    }
    
    
    
    /**
     * convert H, S, B values to {r:red, g:green, b:blue} Object
     * 
     * @param hue 0-360
     * @param saturation 0-100
     * @param brightness 0-100
     * 
     * @return contains r(0-255), g(0-255), n(0-255)
    */
    public static function HSB2RGB(hue:Number, sat:Number, bri:Number):Object{
        
        hue = (hue<0)? hue % 360+360 : (hue>=360)? hue%360: hue;
        sat = (sat<0)? 0 : (sat>100)? 100: sat;
        bri = (bri<0)? 0 : (bri>100)? 100: bri;        
        
        sat *= 0.01;
        bri *= 0.01;
        
        var val:Number
        if(sat == 0){
            val = bri*255;
            return {r:val, g:val, b:val}
        }
        
        var max:Number = bri*255;
        var min:Number = max*(1-sat);
        
        return _hMinMax2RGB(hue, min, max);
    }
    
    
    
    /**
     * convert R,G,B values to {h:huse,s:saturation,b:brightness} Object
     * 
     * @param r Red value 0-255
     * @param g Green value 0-255
     * @param b Blue value 0-255
     * 
     * @return contains h(0-360), s(0-100), b(0-100)
    */
    public static function RGB2HSB(r:int, g:int, b:int):Object{
        r = (r < 0)? 0 : (r>255)? 255: Math.round(r);
        g = (g < 0)? 0 : (g>255)? 255: Math.round(g);
        b = (b < 0)? 0 : (b>255)? 255: Math.round(b);
        
        var min:Number = Math.min(r, g, b);
        var max:Number = Math.max(r, g, b);
        
        //saturation
        if(max==0){
            //明度が０の時は黒
            return {h:0, s: 0, b: 0}
        }else{
            var s:Number = (max - min)/max * 100;
        }
        
        //明度
        //変数名b (BLUE) と混同しないように注意
        var bri:Number = max / 255 * 100;
        
        //色相
        var h:Number = _getHue(r, b, g, max, min);
        return {h:h, s:s, b:bri}
    }


    /**
     * convert R,G,B values to {h:Hue,l:Luminous,s:Saturation} Object
     * 
     * @param r Red value 0-255
     * @param g Green value 0-255
     * @param b Blue value 0-255
     * 
     * @return contains {h:Hue,l:Luminous,s:Saturation}
    */
    public static function RGB2HLS(r:int, g:int, b:int):Object{
        r = (r < 0)? 0 : (r>255)? 255: Math.round(r);
        g = (g < 0)? 0 : (g>255)? 255: Math.round(g);
        b = (b < 0)? 0 : (b>255)? 255: Math.round(b);
        
        var min:Number = Math.min(r,g,b);
        var max:Number = Math.max(r,g,b);
        var l:Number = (max + min)*0.5 / 255 * 100;
        
        var dist:Number = (max - min);
        var h:Number
        var s:Number
        if(dist==0){
            h = 0;
            s = 0;
        }else{
            if( l < 127.5){
                s = dist/(max+min)*100
            }else{
                s = dist/(510-max-min)*100
            }
        
            h = 360 - _getHue(r,g,b,max, min);
        }
        
        return {h:h, l:l, s:s}
    }
    
    
    public static function getLuminous( color:int ) : int
    {
        var r:int = color >> 16 & 0xff;
        var g:int = color >> 8 & 0xff;
        var b:int = color & 0xff;

        var min:Number = Math.min(r,g,b);
        var max:Number = Math.max(r,g,b);
        var l:Number = (max + min)*0.5 / 255 * 100;
        
        
        return l;
    }
    
    
    
    
    
    /**
    --------------------------------------------------------------------------------
        INTERNAL METHOD
    --------------------------------------------------------------------------------
    */
    
    
    
    /*
    * function: _hMinMax2RGB
    * 
    * internal use only
    * 
    * calcurates RGB used in hls, hsb conversion
    */
    private static function _hMinMax2RGB(h:Number, min:Number, max:Number):Object{
        var r:Number,g:Number,b:Number;
        var area:Number = Math.floor(h / 60);
                              
        switch( area){
            case 0:
                r = max
                //0 - 0, 60-255
                g = min+h * (max-min)/ 60;
                b = min
                break;
            case 1:
                r = max-(h-60) * (max-min)/60;
                g = max
                b = min
                break;
            case 2:
                r = min 
                g = max
                b = min+(h-120) * (max-min)/60;
                break;
            case 3:
                r = min
                g = max-(h-180) * (max-min)/60;
                b =max
                break;
            case 4:
                r = min+(h-240) * (max-min)/60;
                g = min
                b = max
                break;
            case 5:
                r = max
                g = min
                b = max-(h-300) * (max-min)/60;
                break;
            case 6:
                r = max
                //0 - 0, 60-255
                g = min+h  * (max-min)/ 60;
                b = min
                break;
        }
        
        r = Math.min(255, Math.max(0, Math.round(r)))
        g = Math.min(255, Math.max(0, Math.round(g)))
        b = Math.min(255, Math.max(0, Math.round(b)))
        
        return {r:r, g:g, b:b}
    }




    /*
    * funciton: _getHue
    * 
    * internal use only
    * 
    *　calucurates hsb
    */
    
    private static function _getHue(r:Number, g:Number, b:Number, max:Number, min:Number):Number{
        var range:Number = max - min;
        if(range==0){
            return 0;
        }
        
        var rr:Number = (max - r)
        var gg:Number = (max - g)
        var bb:Number = (max - b)
        
        var h:Number
        switch(max){
            case r:
                h = bb - gg
                break;
            case g:
                h = 2 *range+ rr - bb
                break;
            case b:
                h = 4 *range+ gg - rr
                break;
        }
        
        h*=-60;
        h/=range;
        h = (h<0)? h+360: h;
        
        return h
    }
    }