/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xWTZ
 */

package {
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.display.Sprite;
    import org.libspark.ukiuki.Ukiuki;
    import org.libspark.ukiuki.ease.Elastic;
    [SWF(frameRate="60")];
    
    public class FlashTest extends Sprite {
        static public const NUM:int = 80;
        private var mouse:Point = new Point();
        
        public function FlashTest() {
            addChild(new Bitmap(new BitmapData(465, 465, false, 0)));
            
            for(var i:int=0; i<NUM; i++) {
                var star:Star = new Star();
                star.x = Math.random() * 465;
                star.y = Math.random() * 465;
                star.blendMode = "add";
                Ukiuki.yoyo(star, {rotation:180},{time:Math.random()*60+30, repeat:-1, ease:Elastic.IN_OUT})
                Ukiuki.chase2D(star, mouse, {gravity:30, inertia:0.99, outType:"cycle"}, {x:-10, y:-10}, {x:475, y:475})
                addChild(star);
            }
            addEventListener("exitFrame",onFrame);            
        }
        private function onFrame(e:Event):void {
            mouse.x = mouseX;
            mouse.y = mouseY;
        }
    }
}

import flash.display.Graphics;
import flash.display.Shape;

class Star extends Shape {
    static public const COLOR:Array = [0xFF6767, 0X6767FF, 0x67FF67, 0x55FFFF, 0xFFFF55, 0xFF55FF];
    static public const R:Number = 11;
    function Star() {
        var g:Graphics = graphics;
        g.beginFill(COLOR[int(Math.random()*COLOR.length)]);
        g.moveTo(0, -R);
        for(var i:int=0; i<10; i++) {
            var dir:Number = Math.PI * 2 / 10 * (i + 1)
            var r:Number = i % 2 == 0 ? R/2 : R;
            g.lineTo(r*Math.sin(dir), -r*Math.cos(dir));
        }
        g.endFill()
        alpha = 0.5;

    }

}
