/**
 * Copyright Geo877 ( http://wonderfl.net/user/Geo877 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xWPP
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Collision.Shapes.b2CircleDef;
    import Box2D.Collision.b2AABB;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.*;
    [SWF(backgroundColor="0xCCCCCC")]
    public class Main extends Sprite {
        private var world:b2World;
        private var body:b2Body;
        private var bodyDef:b2BodyDef; //useful for creating new boddies
        private var drawScale:Number = 30;//30 pixels for every 1 box2D unit
        
        public function Main() {
            //Input setup
            setupKeyboardInput();    
            
            var worldAABB:b2AABB = new b2AABB();
            worldAABB.lowerBound.Set(-100.0, -100.0);
            worldAABB.upperBound.Set(100.0,100.0);
            //create world
            var gravity:b2Vec2 = new b2Vec2(0.0,0.0);
            var canSleep:Boolean = false;
            world = new b2World(worldAABB,gravity,canSleep);
            // set debug draw
            var dbgDraw:b2DebugDraw = new b2DebugDraw();
            dbgDraw.m_sprite = this;
            dbgDraw.m_drawScale = drawScale;
            dbgDraw.m_fillAlpha = 0.3;
            dbgDraw.m_lineThickness = 1.0;
            dbgDraw.m_drawFlags = b2DebugDraw.e_shapeBit | b2DebugDraw.e_jointBit;
            world.SetDebugDraw(dbgDraw);
            
          
            var groundBodyDef:b2BodyDef = new b2BodyDef(); 
            var groundShapeDef:b2PolygonDef = new b2PolygonDef();
            //Top
            groundBodyDef.position.Set(0.0, -10.0);
            groundShapeDef.SetAsBox(50.0, 10.0);
            world.CreateBody(groundBodyDef).CreateShape(groundShapeDef);
            //Right
            groundBodyDef.position.Set(stage.stageWidth/drawScale+10, 0.0);
            groundShapeDef.SetAsBox(10.0, 50.0);
            world.CreateBody(groundBodyDef).CreateShape(groundShapeDef);
            //Bottom
            groundBodyDef.position.Set(0.0, stage.stageHeight/drawScale+10);
            groundShapeDef.SetAsBox(50.0, 10.0);
            world.CreateBody(groundBodyDef).CreateShape(groundShapeDef);
            //Left
            groundBodyDef.position.Set(-10.0, 0.0);
            groundShapeDef.SetAsBox(10.0, 50.0);
            world.CreateBody(groundBodyDef).CreateShape(groundShapeDef);
            
            
            //Free Bodies
            bodyDef = new b2BodyDef();
            var shapeDef:b2PolygonDef = new b2PolygonDef();
            bodyDef.angle = 0;
            bodyDef.position.Set(stage.stageWidth/(drawScale*2), stage.stageHeight/(drawScale*2));
            shapeDef.SetAsBox(0.8, 1.0);
            shapeDef.density = 1.0;
            shapeDef.friction = 0.3;
            body = world.CreateBody(bodyDef);
            body.CreateShape(shapeDef);
            body.SetMassFromShapes();
            
            //Free Circles
            var circleBody:b2Body;
            var circleDef:b2CircleDef = new b2CircleDef();
            var i:int = 10;
            while(i>0){
                //Make circle shape and attach to bint
                circleDef.density = 1.0;
                circleDef.radius = Math.random()*0.4+0.05;
                bodyDef.position.Set((Math.random()*(stage.stageWidth-80)+40)/drawScale,(Math.random()*(stage.stageHeight-80)+40)/drawScale);
                circleBody = world.CreateBody(bodyDef);
                circleBody.CreateShape(circleDef);
                circleBody.SetMassFromShapes();
                i--;
            }
            
            this.addEventListener(Event.ENTER_FRAME,mainLoop);
  
        }
        
        private function mainLoop(e:Event = null):void{
            handleInput();
            world.Step(1/60, 10);
        }
        
        private function handleInput(e:Event = null):void{
             if(keyIsDown(38)){
                 body.ApplyForce(body.GetWorldVector(new b2Vec2(0.0,30)),body.GetWorldPoint(new b2Vec2(0,0)));
             }
             if(keyIsDown(40)){
                 body.ApplyForce(body.GetWorldVector(new b2Vec2(0.0,-30)),body.GetWorldPoint(new b2Vec2(0,0)));
             }
             if(keyIsDown(39)){
                 body.ApplyTorque(20.0);
             }
             if(keyIsDown(37)){
                 body.ApplyTorque(-20.0);
             }             
        }

        private var keyArray:Array;
        private function setupKeyboardInput():void{keyArray = new Array();          
            stage.addEventListener(KeyboardEvent.KEY_DOWN,keyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP,keyUp);}
        private function keyUp(e:KeyboardEvent = null):void{keyArray[e.keyCode] = false;}
        private function keyDown(e:KeyboardEvent = null):void{keyArray[e.keyCode] = true;}
        public function keyIsDown(keyCode:int):Boolean{if(keyArray[keyCode]==true)return true;return false;}
        
  
    }
}