/**
 * Copyright mash ( http://wonderfl.net/user/mash )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xWP3
 */

// loading fonts by hand
// but I'm sure you don't want to do this by yourself,
// so use net.wonderfl.utils.FontLoader
// see: http://wonderfl.net/c/4tnW
package {
    import flash.events.*;
    import flash.text.*;
    import flash.net.*;
    import flash.display.*;
    import flash.system.*;

    public class FlashTest extends Sprite {
        public function FlashTest() {
            var fonts :Array = ["Aqua","Azuki","Cinecaption","Mona","Sazanami","YSHandy","VLGothic","IPAGP","IPAM","UmeUgo","UmePms","Bebas"];
            fonts.forEach( function( font :String, i:int, a:Array ) :void {
                loadFontAndDraw( font );
            });
           
        }

        private var offset :int = 0;
        private function loadFontAndDraw( font :String ) :void {
            var ld :Loader = new Loader;
                ld.load(
                    new URLRequest("http://assets.wonderfl.net/static/fonts/"+font+".swf"),
                    new LoaderContext(
                        true,
                        ApplicationDomain.currentDomain, 
                        SecurityDomain.currentDomain
                    )
                );
                ld.contentLoaderInfo.addEventListener( Event.COMPLETE, function(e :Event) :void {
                    var fontClass :Class = ApplicationDomain.currentDomain.getDefinition( "net.wonderfl.fonts." + font + "_font" ) as Class;
                    Font.registerFont( fontClass );

                    var tf :TextField = fontedTextField( font );
                    tf.y = offset;
                    addChild( tf );

                    offset += 30;
                });
        }

        private function fontedTextField( font :String ) :TextField {
            var tf :TextField = new TextField;
            tf.defaultTextFormat = new TextFormat( font, 22, 0x000000 );
            tf.embedFonts = true;
            tf.width = 465;
            tf.text = font + ": Hello, World! こんにちは、世界！";
            return tf;
        }
    }
}
