/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xW6D
 */

// forked from siouxcitizen's PV3DのTriangleMesh3Dの練習02　自分用に分かりやすく修正
//PV3DのTriangleMesh3Dの練習03　ピラミッド型の作成
//ピラミッドかどうかちょっと確認しづらいですが。。。
//
//↓今回のコードを作成するにあたって以下のサイト＆コードを参考にさせて頂きました
//[Papervision3D2.0] TriangleMesh3D
//http://blog.r3c7.net/?p=136
package
{
    import flash.events.Event;

    import org.papervision3d.core.geom.TriangleMesh3D;
    import org.papervision3d.core.geom.renderables.Triangle3D;
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.core.math.NumberUV;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.view.BasicView;

    [SWF(width="640", height="480", backgroundColor="#000000", frameRate="60")]
    public class TriangleMesh3DExample extends BasicView
    {
        private var mesh : TriangleMesh3D;
        private var size : int = 200;//オブジェクトの長さ

        public function TriangleMesh3DExample() {
            //マテリアル設定
            var material:ColorMaterial = new ColorMaterial(0xFFAA00,1.0);
            material.doubleSided = true;

            //TriangleMesh3Dオブジェクト生成
            mesh = new TriangleMesh3D( material, new Array(), new Array(), null );
            scene.addChild(mesh);

            //頂点定義
            //size = 200の場合
            //var v0 : Vertex3D = new Vertex3D(-200, -200, 200);
            //var v1 : Vertex3D = new Vertex3D(200, -200, 200);

            //var v2 : Vertex3D = new Vertex3D(200, 200, 0);

            //var v3 : Vertex3D = new Vertex3D(-200, -200, -200);
            //var v4 : Vertex3D = new Vertex3D(200, -200, -200);

            var v0 : Vertex3D = new Vertex3D(-size, -size, size);
            var v1 : Vertex3D = new Vertex3D(size, -size, size);

            var v2 : Vertex3D = new Vertex3D(0, size, 0);

            var v3 : Vertex3D = new Vertex3D(-size, -size, -size);
            var v4 : Vertex3D = new Vertex3D(size, -size, -size);

            mesh.geometry.vertices.push( v0 );
            mesh.geometry.vertices.push( v1 );
            mesh.geometry.vertices.push( v2 );
            mesh.geometry.vertices.push( v3 );
            mesh.geometry.vertices.push( v4 );
            //面定義
            var uvA : NumberUV = new NumberUV( 0, 0 );
            var uvC : NumberUV = new NumberUV( 1, 0 );
            var uvB : NumberUV = new NumberUV( 0, 1 );

            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v0,v1,v2), null, new Array(uvA,uvC,uvB) ));
            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v3,v4,v2), null, new Array(uvA,uvC,uvB) ));
            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v3,v0,v2), null, new Array(uvA,uvC,uvB) ));
            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v1,v4,v2), null, new Array(uvA,uvC,uvB) ));
            mesh.geometry.ready = true;

            startRendering();
        }

        override protected function onRenderTick(event:Event=null):void {
            mesh.rotationX=viewport.mouseX;
            mesh.rotationY=viewport.mouseY;
            super.onRenderTick(event);
        }
    }
}