/**
 * Copyright JoshChernoff ( http://wonderfl.net/user/JoshChernoff )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xW0k
 */

package
{
    
    /*
    
    The problem is that I have a mouse over/out listenr on a parent displayObject and when you roll over any of its nested children
    a mouse out is dispatched on the parent even though you have not roll off the parent since the whole thing is the parent container. 
    
    This is a issue of depth vs. containment. The parent is the whole thing thus unless I roll off the parent it should never 
    dispatch  a mosue out on it. 
    
    to see the issue roll Over the bigger blue circle and then directly over the small circle from the bigger circle. 
    you will see the mouse event out dispatches even though the little circle is inide the bigger one. 
    
    the idea is simple the little blue circle must be able to listen to its own mouse over/out but must not cause parent to dispatch mouse out.  
    Thanks for your help
    - Josh  
    
    */
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.MouseEvent;
    public class Main extends Sprite
    {
        
        private var tf:TextField = new TextField();
        private var i:int = 0;
        private var mc:MovieClip;
        private var mc2:MovieClip;
        public function Main()
        {
            tf.autoSize = "left";
            this.addChild(tf);
            
            mc = new MovieClip();
            mc.name = "mc";
            mc.x=mc.y=100;
            mc.graphics.beginFill(0x0000FF);
            mc.graphics.drawCircle(50, 50, 50);
            mc.buttonMode = true;
            mc.mouseChildren = true
            
            mc.addEventListener(MouseEvent.ROLL_OVER , onMouseOver);
            mc.addEventListener(MouseEvent.ROLL_OUT,   onMouseOut);
            
            this.addChild(mc);
            
            //NOTE mc2 also needs to be able to listen for mouse over / out events too
            mc2  = new MovieClip();
            mc2.name = "mc2";
            mc2.x = mc2.y = 25;
            mc2.graphics.beginFill(0x0FF0FF);
            mc2.graphics.drawCircle(20, 20, 20);
            
            mc2.addEventListener(MouseEvent.ROLL_OVER, onMouseOver2);
            mc2.addEventListener(MouseEvent.ROLL_OUT,  onMouseOut2); 
            
            mc.addChild(mc2); //mc is the parent and is the whole container 
        }
        private function onMouseOver(e:MouseEvent) : void
        {
            e.stopImmediatePropagation();
        }
        private function onMouseOut(e:MouseEvent) : void
        {    
            e.stopImmediatePropagation();
    
            tf.text = i++ + " - Mouse Out - " + e.target.name + " - currentTarget: " + e.currentTarget.name; //if this traces when you roll over the little blue circle then you have faild
        }
        
        private function onMouseOver2(e:MouseEvent):void{
            e.stopImmediatePropagation();
            mc2.graphics.clear();
            mc2.graphics.beginFill(0xFFF000);
            mc2.graphics.drawCircle(20, 20, 20);

        }
        private function onMouseOut2(e:MouseEvent):void{
            e.stopImmediatePropagation();
            mc2.graphics.clear();
            mc2.graphics.beginFill(0x0FF0FF);
            mc2.graphics.drawCircle(20, 20, 20); 
        }
    }
}