/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xVnD
 */

// forked from tepe's オブジェクトマップ
// forked from tepe's ノード配置
package{
    import flash.geom.Point;
    import caurina.transitions.Tweener;
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    import flash.ui.*;
    import flash.utils.*;
    import flash.net.navigateToURL;
    import flash.net.URLRequest;
    import flash.filters.*;
    import com.actionsnippet.qbox.*;

    [SWF(backgroundColor=0, width=465, height=465)]
    public class node extends Sprite{

        private var btn1:Btn;
        
        private var text1:TextField;
        private var text2:TextField;
        private var text3:TextField;
        
        private var scale:Number = 1;
        
        private var wheel:int;//ホイール回転量
        private var zoom:Number = 1.0;//拡大率
        private var map:Sprite;//フィールド
        
        private var mapFocusX:Number=0;
        private var mapFocusY:Number=0;
        private var scrFocusX:int=0; 
        private var scrFocusY:int=0; 
        private var mX:int=0; 
        private var mY:int=0; 
        
        private var scalingPanel:Sprite;
        private var base:Sprite;
              
        private var lineA:Shape;
        private var lineB:Shape;
        private var lineC:Shape;
        private var mapscale:int=0;
        
        private var normalscrsizeX:Number;
        private var StagedispLeft:Number;//フルスクリーン時のディスプレイ原点(stageで値)
        private var StagedispRight:Number;
        
        private var obj:Sprite;//ノード
        
        private var onDrag:Boolean;//ドラッグフラグ
        
       
        
        
        //コンストラクタ 
        public function node():void{
            
            //stage.scaleMode = "noScale";
            
            //stage.scaleMode = "noBorder";
            
            
            //カーソル位置描画
            scalingPanel = new Sprite();
            scalingPanel.graphics.lineStyle(1,0xffffff,0.5);
            scalingPanel.graphics.moveTo(-5,-10);
            scalingPanel.graphics.lineTo(-10,-10);
            scalingPanel.graphics.lineTo(-10,-5);
            scalingPanel.graphics.moveTo(5,-10);
            scalingPanel.graphics.lineTo(10,-10);
            scalingPanel.graphics.lineTo(10,-5);
            scalingPanel.graphics.moveTo(-5,10);
            scalingPanel.graphics.lineTo(-10,10);
            scalingPanel.graphics.lineTo(-10,5);
            scalingPanel.graphics.moveTo(5,10);
            scalingPanel.graphics.lineTo(10,10);
            scalingPanel.graphics.lineTo(10,5);
   
            //マウスイベント
            scalingPanel.addEventListener(MouseEvent.MOUSE_DOWN,down1);
            scalingPanel.addEventListener(MouseEvent.MOUSE_UP,up1);
            addChild(scalingPanel);
            
            lineA = new Shape();
            lineB = new Shape();
            lineC = new Shape();
            
            //マップ基準座標
            base = new Sprite();
            base.graphics.lineStyle(1,0xff0000,1);
            base.graphics.moveTo(-100,0);
            base.graphics.lineTo(100,0);
            base.graphics.moveTo(0,-100);
            base.graphics.lineTo(0,100);
            scalingPanel.addChild(base);
            
            //マップ
            map = new Sprite();
            map.graphics.lineStyle(1,0xffffff);
            map.graphics.beginFill(0x003300,0.5);
            map.graphics.drawRect(-320,-320,640,640);
            map.graphics.endFill();
            map.addEventListener(MouseEvent.MOUSE_DOWN,down1);
            map.addEventListener(MouseEvent.MOUSE_UP,up1);
            
            map.addChild(lineB);
            map.addChild(lineA);
            map.addChild(lineC);
            
            btn1 = new Btn();
            btn1.init({label:"full screen",type:2,width:100});
            btn1.x = 200; btn1.y = 445;
            btn1.z = 0;
            addChildAt(btn1,1);
          
  
            btn1.addEventListener("click",fullscreen);
   
            
            text1 = new TextField();
            text1.selectable = false;
            text1.textColor = 0xffffff;
            text1.y = 400;
            text1.text = "test";
            addChild(text1);
            
            text2 = new TextField();
            text2.selectable = false;
            text2.textColor = 0xffffff;
            text2.y = 420;
            text2.text = "test";
            addChild(text2);
            
            
            // クリックイベントを監視する
            map.addEventListener("click", clickHandler);//クリック→ノード配置
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);//マウスアップ
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE,on_mouseMove);//カーソル移動
            addEventListener(MouseEvent.MOUSE_WHEEL,on_wheel);//ホイール操作 
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);//メインループ
 
            base.addChildAt(map,0); 
            //addChild(btn1);
            //addChildAt(btn1,1);
        }
        
        //マップドラッグ
        private function down1(event:MouseEvent):void{
      　    event.target.startDrag();
      　    event.stopPropagation();//イベントの伝播を止める
        }
        private function up1(event:MouseEvent):void{
            event.target.stopDrag();
            event.stopPropagation();//イベントの伝播を止める
        }


        
        //ホイール操作
        private function on_wheel(event:MouseEvent):void{
            wheel += event.delta;    
        }
        

        
        //メインループ
        private function enterFrameHandler(e:Event):void {

            text2.text = "scale:"+mapscale;
            
            mX = mouseX; mY = mouseY;
            on_zoom();
            
            
            scalingPanel.x = mouseX; 
            scalingPanel.y = mouseY; 
            base.x -= (mX-scrFocusX)/zoom; base.y -= (mY-scrFocusY)/zoom;
            scrFocusX = mX; scrFocusY = mY;
            

            
            //フィールドドラッグ用
            lineB.graphics.clear();
            lineB.graphics.beginFill(0x000000,0);
            lineB.graphics.drawCircle(-(map.x+map.parent.x)/map.scaleX,-(map.y+map.parent.y)/map.scaleY,100/map.scaleX);
            lineB.graphics.endFill();
     
        }
        
        
        private function on_zoom():void{
            text1.text = "zoom="+zoom+" ";
            if(wheel != 0){
                if(wheel < 0){
                    zoom *= 1+(0.005*wheel);
                    //wheel++;
                    //base.x = mouseX; base.y = mouseY;
                    //text2.text = "wheel="+wheel+" ";
                }
                else if(0 < wheel){
                    zoom *= 1+(0.005*wheel);
                    //wheel--;
                    //text2.text = "wheel="+wheel+" ";
                }
                
                
                if(2 < zoom){

                    map.scaleX *= 2;
                    map.scaleY *= 2;
                    zoom /= 2;
                    map.x += map.x+base.x;
                    map.y += map.y+base.y;
                    
                    mapscale--;
                    
                    
                }
                else if(zoom < 1.0){
                    
      
                    
                    map.x -= (map.x+base.x)/2;
                    map.y -= (map.y+base.y)/2;
                    zoom *= 2;
                    map.scaleX /= 2;
                    map.scaleY /= 2;
                    
                    mapscale++;
                    
                }
                scalingPanel.scaleX = zoom;
                scalingPanel.scaleY = zoom;
            
        }
                
                
                
            }
   




        
        private function on_mouseMove(event:MouseEvent):void{
            text1.text = "x=" + event.stageX + " y="+ event.stageY + " ";
        }

        
        //クリック
        private function clickHandler(event:MouseEvent):void {
            
            if(wheel!=0){
               wheel = 0;
            }
            else{
                // 円を作成
                obj = new Sprite();
                obj.graphics.lineStyle(1,0xffffff);
                var color:uint = Math.random()*0x1000000;
           
                obj.graphics.beginFill(color, Math.random()*1.0);
                obj.graphics.drawCircle(0, 0, 10);
                obj.filters = [new GlowFilter(color, 0.5, 16, 16, 4, 2)]; 
                obj.blendMode = BlendMode.ADD;
                obj.graphics.endFill();
                event.target.addChild(obj);
                 // イベントリスナー
                obj.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);



                // 円をクリックされた位置に移動
                obj.x = event.localX; 
                obj.y = event.localY; 
                obj.scaleX = obj.scaleY = 5;
                obj.alpha = 0;
                
                //アニメーション処理
                Tweener.addTween(obj, {
                    time: 0.5,    // アニメーション時間
                    scaleX: Math.pow(scale,mapscale),  // s の scaleX を 指定値 まで遷移
                    scaleY: Math.pow(scale,mapscale),  // s の scaleY を 指定値 まで遷移
                    alpha: 1,//不透明率
                    transition: "easeOutBounce"//バウンドアニメーション
                });
            
                //var timer:Timer = new Timer(500, 1);
                obj.addEventListener(MouseEvent.ROLL_OVER,rollOver);
                obj.addEventListener(MouseEvent.ROLL_OUT,rollOut);
                //timer.addEventListener(TimerEvent.TIMER,addroll);            

                //timer.start();    
            }  
    
        }    
        
        private function rollOver():void{
            //    ロールオーバー            
         
            Tweener.addTween(obj, {
                    time: 0.2,    // アニメーション時間
                    scaleX: scaleX*2,  // s の scaleX を 指定値 まで遷移
                    scaleY: scaleY*2,  // s の scaleY を 指定値 まで遷移
                    alpha: 100,//不透明率
                    transition: "liner"
                    });
                    text2.text = obj.name;
                    
        }
        
        private function rollOut():void{
            
            //    ロールアウト
            Tweener.addTween(obj, {
                    time: 0.2,    // アニメーション時間
                    scaleX: scaleX,  // s の scaleX を 指定値 まで遷移
                    scaleY: scaleY,  // s の scaleY を 指定値 まで遷移
                    alpha: 1,//不透明率
                    transition: "liner"
                    });
        }

        
        
        //スクロール
        private function mapscrool( event:Event ):void{
            //StagedispLeft = (normalscrsizeX - stage.width)/2;
            //StagedispRight = stage.width + normalscrsizeX;
            text2.text = "h:"+stage.height+" y:"+stage.mouseY;
            //if(stage.mouseX < StagedispLeft+10)map.x+= 10/zoom;
            //else if(StagedispRight-10 < stage.mouseX)map.x-= 10/zoom;
            if(stage.mouseY < 10)map.y += stage.mouseY/zoom;
            else if(stage.height-10 < stage.mouseY)map.y += (10+stage.mouseY-stage.height)/zoom;
            
        }

  
 
        
        //画面モード切り替え
        private function fullscreen( event:MouseEvent ):void{          
            if(stage.displayState == StageDisplayState.FULL_SCREEN){
                stage.displayState = StageDisplayState.NORMAL;//元に戻す
                stage.removeEventListener(Event.ENTER_FRAME,mapscrool);
            }
            else{
                normalscrsizeX = stage.width;
                stage.displayState = StageDisplayState.FULL_SCREEN;//フルスクリーンモード

                stage.addEventListener(Event.ENTER_FRAME,mapscrool);
            }
            event.stopPropagation();//イベントの伝播を止める            
        }


            
        //マウスダウンイベントの処理
        private function onMouseDown(evt:MouseEvent):void {
            //ドラッグ開始
            if(wheel != 0)wheel = 0;
            evt.target.startDrag();
            evt.stopPropagation();//イベントの伝播を止める
       }

        //マウスアップイベントの処理
        private function onMouseUp(evt:MouseEvent):void {
            if(wheel != 0)wheel = 0;
            evt.target.stopDrag();
            evt.stopPropagation();//イベントの伝播を止める
  
        }
        
    }
}



//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////


import flash.display.*;
import flash.text.*;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0x0099FF;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}




