/**
 * Copyright yasnis ( http://wonderfl.net/user/yasnis )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xVkT
 */

package {
    import flash.display.Sprite;
    [SWF(backgroundColor = 0x000000, frameRate = 60)]
    public class FlashTest extends Sprite {
        
        public function FlashTest() {
            // write as3 code here..
            LifeCell.init(stage);
        }
    }
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.DisplayObjectContainer;
import flash.display.Graphics;
import flash.display.MovieClip;
import flash.display.Sprite;
import flash.events.Event;
import flash.filters.BlurFilter;
import flash.filters.GlowFilter;
import flash.geom.ColorTransform;
class LifeCell extends Sprite {
        static private var celllist:Array;
        static private var rowsCols:Array;
        
        static private var controller:Sprite;
        static private var holder:DisplayObjectContainer;
        
        static private const W:int = 25;
        static private const H:int = 25;
        
        static private const GLOW:GlowFilter = new GlowFilter(0x6600FF, 1, 4, 4, 3, 3);
        static private const BLUR:BlurFilter = new BlurFilter(2, 2, 3);
        
        static private var bmpd:BitmapData;
        static private var bmp:Bitmap;
        
        static private const CTF:ColorTransform = new ColorTransform(.95, .95, .9, 1, 0, 0, 0, 0);
        //static private const CTF:ColorTransform = new ColorTransform(.5, .5, .5, 1, 0, 0, 0, 0);
        
        static private var framecount:int = 0;
        
        static public function init(target:DisplayObjectContainer):void {
            holder = new Sprite();
            //holder.visible = false;
            target.addChild(holder);
            celllist = new Array();
            rowsCols = new Array();
            controller = new Sprite();
            
            
            bmpd = new BitmapData(target.stage.stageWidth, target.stage.stageHeight, false, 0xff000000);
            bmp = new Bitmap(bmpd);
            target.addChild(bmp);
            
            createCell();
            controller.addEventListener(Event.ENTER_FRAME, enterframe);
        }
        
        static private function createCell():void
        {
            var cols:int = (holder.stage.stageWidth / W) >> 0;
            var rows:int = (holder.stage.stageHeight / H) >> 0;
            var r:int = 0;
            var c:int = 0;
            var cell:LifeCell;
            var rowlist:Array;
            while (r<=rows)
            {
                rowlist = new Array();
                rowsCols.push(rowlist);
                while (c<=cols)
                {
                    cell = new LifeCell();
                    cell.col = c;
                    cell.row = r;
                    cell.x = c * W;
                    cell.y = r * H;
                    cell.filters = [GLOW, BLUR];
                    holder.addChild(cell);
                    celllist.push(cell);
                    rowlist.push(cell);
                    cell.visible = cell.isLive = Math.random() < .5;
                    c++;
                }
                r++;
                c = 0;
            }
        }
        
        static private function enterframe(e:Event):void
        {
            bmpd.colorTransform(bmpd.rect, CTF);
            if (++framecount % 20 == 0) {
                calc();
                update();
            }
            bmpd.draw(holder);
        }
        
        static private function calc():void
        {
            var rowlist:Array;
            var cell:LifeCell;
            
            var c00:LifeCell;
            var c01:LifeCell;
            var c02:LifeCell;
            var c10:LifeCell;
            var c12:LifeCell;
            var c20:LifeCell;
            var c21:LifeCell;
            var c22:LifeCell;
            var n:int = 0;
            for (var i:int = 0; i < rowsCols.length; i++)
            {
                rowlist = rowsCols[i];
                for (var j:int = 0; j < rowlist.length; j++)
                {
                    cell = rowlist[j];
                    n = 0;
                    
                    c00 = getCell(cell.row - 1, cell.col - 1);
                    c01 = getCell(cell.row - 1, cell.col);
                    c02 = getCell(cell.row - 1, cell.col + 1);
                    c10 = getCell(cell.row, cell.col - 1);
                    c12 = getCell(cell.row, cell.col + 1);
                    c20 = getCell(cell.row + 1, cell.col - 1);
                    c21 = getCell(cell.row + 1, cell.col);
                    c22 = getCell(cell.row + 1, cell.col + 1);
                    if (c00 && c00.visible) n++;
                    if (c01 && c01.visible) {
                        n++;
                    }
                    if (c02 && c02.visible) n++;
                    if (c10 && c10.visible) n++;
                    if (c12 && c12.visible) n++;
                    if (c20 && c20.visible) n++;
                    if (c21 && c21.visible) n++;
                    if (c22 && c22.visible) n++;
                    
                    if (n <= 1) cell.isLive = false;
                    else if (n <= 3 && n != 2 ) cell.isLive = true;
                    else cell.isLive = false;
                    
                    if (!cell.isLive) cell.isLive = Math.random() < 0.1;
                }
            }
        }
        
        static private function getCell(r:int, c:int):LifeCell {
            var rows:Array = rowsCols[r];
            if (!rows || rows.length < 1) return null;
            var cell:LifeCell = rows[c];
            return cell;
        }
        
        static private function update():void
        {
            var cell:LifeCell;
            for (var i:int = 0; i < celllist.length; i++)
            {
                cell = celllist[i];
                cell.visible = cell.isLive;
            }
        }
        
        private var _row:int = 0;
        private var _col:int = 0;
        private var _isLive:Boolean = true;
        private var _around:int = 0;
        public function LifeCell() {
            
            var g:Graphics = graphics;
            g.beginFill(0xff0000);
            g.drawCircle(12.5, 12.5, 3);
            g.endFill();
            
        }
        
        public function get row():int
        {
            return _row;
        }
        
        public function set row(value:int):void
        {
            _row = value;
        }
        
        public function get col():int
        {
            return _col;
        }
        
        public function set col(value:int):void
        {
            _col = value;
        }
        
        public function get isLive():Boolean
        {
            return _isLive;
        }
        
        public function set isLive(value:Boolean):void
        {
            _isLive = value;
        }
        
        public function get around():int
        {
            return _around;
        }
        
        public function set around(value:int):void
        {
            _around = value;
        }
    }