/**
 * Copyright moonthug ( http://wonderfl.net/user/moonthug )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xVOB
 */

package {
    import flash.display.DisplayObject;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.GlowFilter;
    import flash.text.TextField;
    import flash.text.TextFormat;
        
    import net.hires.debug.Stats;
        
    [SWF(backgroundColor="#000000", height="600", width="900", frameRate="24")];

    public class SpringZ extends Sprite
    {
        private var numParticles:Number = 20;
        private var minDist:Number = 300;
        private var finalDist:Number = 50;
        private var springAmount:Number = .0009;
        private var friction:Number = 1;
        
        private var showSprings:Boolean = true;
        private var showInfo:Boolean = false;
        private var hasBoundaries:Boolean = false;
        
        private var mouseOn:Boolean = false;
        private var glowOn:Boolean = false;
        
        private var shape:String = "dot" //plus, dot, cross, square
        
        private var particleArray:Array = new Array()
        private var colorArray:Array = new Array(0xFFFFFF, 0x40FFA6, 0xFFFB5A, 0xFF47B7);
        private var container:MovieClip = new MovieClip();

        public function SprinZ()
        {
            _init();
            _initListeners();

            //this.addChild(new Stats());
        }
        
        private function _init():void
        {
            if(glowOn==true){
                var myFilters:Array = new Array();
                var filter:GlowFilter = new GlowFilter(0xffffff, 1, 20, 20, 1, 1, false, false);
                myFilters.push(filter);
                   container.filters = myFilters;
              }
                       
            this.addChild(container);

            for(var i:Number=0;i<numParticles;i++)
            {
                var particle:Particle = _createParticle();
                this.container.addChild(particle);
            }    
        }
        
        private function _initListeners():void
        {
            this.addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
            this.stage.addEventListener(MouseEvent.MOUSE_DOWN, _mousePressHandler);
        }
        
        private function _mousePressHandler(e:MouseEvent):void
        {
            var particle:Particle = _createParticle(mouseX, mouseY, 1);
            this.container.addChild(particle);
        }
        
        private function _createParticle(setX:Number = 0, setY:Number = 0, setScale:Number = 0):Particle
        {
            if(!setX){
                setX = Math.random() * this.stage.stageWidth;
            }
            
            if(!setY){
                setY = Math.random() * this.stage.stageHeight;
            }
                        
            var particle:Particle = new Particle(shape);
            particle.x = setX;
            particle.y = setY;
            particle.vx = Math.random() * 6 - 3;
            particle.vy = Math.random() * 6 - 3;
            
            particle.scaleX = particle.scaleY = Math.random() + setScale;
            particle.mass = particle.scaleX / 100;
            
            var randomColor:Number = Math.floor(Math.random() * colorArray.length);
            particle.springColor = colorArray[randomColor];
            
                        
//            var myFilters:Array = new Array();
//            var filter:GlowFilter = new GlowFilter(colorArray[randomColor], 1, 10, 10, 10, 3, false, false);
//                    myFilters.push(filter);
//               particle.filters = myFilters;
            
            particleArray.push(particle);
            
            return particle;
        }
        

        private function _enterFrameHandler(e:Event):void
        {
            for(var i:Number = 0;i<particleArray.length;i++)
            {
                var particle:Particle = particleArray[i];
                
                particle.x += particle.vx;
                particle.y += particle.vy;
                
                if(hasBoundaries==false){
                    if(particle.x > this.stage.stageWidth){
                        particle.vx *= (friction * -1);
                    }else if(particle.x < 0){
                        particle.vx *= (friction * -1);
                    }

                    if(particle.y > this.stage.stageHeight){
                        particle.vy *= (friction * -1);
                    }else if(particle.y < 0){
                        particle.vy *= (friction * -1);
                    }
                }else{
                    if(particle.x > this.stage.stageWidth){
                        particle.x = 0;
                    }else if(particle.x < 0){
                        particle.x = this.stage.stageWidth;
                    }

                    if(particle.y > this.stage.stageHeight){
                        particle.y = 0;
                    }else if(particle.y < 0){
                        particle.y = this.stage.stageHeight;
                    }
                }
                
                //friction
                particle.vy *= friction;
                particle.vx *= friction;
                
                    container.graphics.clear();
                
                    for(i=0;i<particleArray.length;i++)
                    {
                        var partA:Particle = particleArray[i];
                        for(var j:Number = i+1;j<particleArray.length;j++)
                        {
                            var partB:Particle = particleArray[j];
                            _spring(partA, partB);
                        }
                
                        if(mouseOn==true){
                            _mouseSpring(partA);
                        }
                    }
                        }
            
        }

        private function _spring(partA:Particle, partB:Particle):void
        {
            var dx:Number = partB.x - partA.x;
            var dy:Number = partB.y - partA.y;
            var dist:Number = Math.sqrt(dx*dx + dy*dy);
            
            if(dist < minDist)
            {
                if(showSprings==true){
                    //this.graphics.lineStyle(partA.vx, partA.springColor, (100 - dist / minDist * 100) / 100);
                    container.graphics.lineStyle(1, partA.springColor, (100 - dist / minDist * 100) / 100);
                    container.graphics.moveTo(partA.x, partA.y);
                    container.graphics.lineTo(partB.x, partB.y);
                }
                
                var ax:Number = dx * (springAmount / 1000);
                var ay:Number = dy * (springAmount / 1000);
                
                partA.vx += ax / partA.mass;
                partA.vy += ay / partA.mass;
                partB.vx -= ax / partB.mass;
                partB.vy -= ay / partB.mass;
            }
            
        }
        
        private function _mouseSpring(partA:Particle):void
        {
            var dx:Number = mouseX - partA.x;
            var dy:Number = mouseY - partA.y;
            var dist:Number = Math.sqrt(dx*dx + dy*dy);
            
            if(dist < 800)
            {
                if(showSprings==true){
                    container.graphics.lineStyle((partA.vx + partA.vy)/2, partA.springColor, (100 - dist / minDist * 100) / 100);
                    //container.graphics.lineStyle(1, 0x00CCFF, (100 - dist / 800 * 100) / 100);
                    container.graphics.moveTo(partA.x, partA.y);
                    container.graphics.lineTo(mouseX, mouseY);
                }
                
                var ax:Number = dx * (springAmount / 10);
                var ay:Number = dy * (springAmount / 10);
                
                partA.vx += ax / partA.mass;
                partA.vy += ay / partA.mass;
            }
            
        }

    }
}

        import flash.display.Graphics;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;

    
        class Particle extends MovieClip
    {
        public var vx:Number;
        public var vy:Number;
        public var mass:Number;
        public var springColor:Number;
        public var isMouse:Boolean = false;
        public var maxSpeed:Number = 10;
        
        public var infoText:TextField;
        
        public var dot:MovieClip = new MovieClip();
        
        function Particle(shape:String)
        {
            super();
            
            switch(shape){
                case "dot":
                    dot.graphics.beginFill(0xffffff);
                    dot.graphics.drawCircle(0,0,2);
                    dot.graphics.endFill();
                    break;
                case "square":
                    dot.graphics.beginFill(0xffffff);
                    dot.graphics.drawRect(0,0,5,5);
                    dot.graphics.endFill();
                    break;
                case "plus":        
                    dot.graphics.lineStyle(1, 0xffffff);
                    dot.graphics.moveTo(0, -10)
                    dot.graphics.lineTo(0,10);
                    dot.graphics.moveTo(-10,0);
                    dot.graphics.lineTo(10,0);
                    break;
                case "cross":
                    dot.graphics.lineStyle(1, 0xffffff);
                    dot.graphics.moveTo(-5, 5)
                    dot.graphics.lineTo(5, -5);
                    dot.graphics.moveTo(-5, -5);
                    dot.graphics.lineTo(5,5);
            }
            
            dot.alpha = 0.5;
            this.addChild(dot);

            this.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            
        }
        
        private function enterFrameHandler(e:Event):void
        {
            if(this.vx > maxSpeed){
                this.vx *= 0.8;
            }
            if(this.vy > maxSpeed){
                this.vy *= 0.8;
            }
            //infoText.text = Math.round(this.vx) + ", " + Math.round(this.vy);
        }
    }

