/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xUi9
 */

package  
{
	import com.bit101.components.List;
	import com.bit101.components.TextArea;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.net.URLRequest;
	
	/**
	 * FP10.1から追加されたクラスを見て見る。
	 * @author jc at bk-zen.com
	 */
	[SWF (width = "465", height = "465")]
	public class FlashTest extends Sprite
	{
		private var list:List;
		private var desc:TextArea;
		private var top: Sprite;
		private var listResizer:ResizeComp;
		private var loader:Loader;
		
		public function FlashTest() 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			//
			
			top = new Sprite();
			list = new List();
			list.items = CLASSES;
			list.setSize(stage.stageWidth / 4, stage.stageHeight);
			list.addEventListener(Event.SELECT, onSelect);
			listResizer = new ResizeComp(top, list, ResizeComp.HORIZONTAL, 5);
			listResizer.addEventListener(Event.RESIZE, onResizeList);
			addChild(listResizer);
			desc = new TextArea(this, list.width + 5, 0);
			desc.setSize(stage.stageWidth / 4 * 3 - 5, stage.stageHeight);
			stage.addEventListener(Event.RESIZE, onResize);
			addChild(top);
		}
		private function onSelect(e:Event):void 
		{
			desc.text = list.selectedItem.value;
		}
		
		private function onResizeList(e:Event):void 
		{
			desc.x = list.width + 5;
			desc.setSize(stage.stageWidth - list.width - 5, stage.stageHeight);
		}
		
		private function onResize(e:Event):void 
		{
			list.setSize(stage.stageWidth / 4, stage.stageHeight);
			listResizer.draw();
			desc.x = list.width + 5;
			desc.setSize(stage.stageWidth / 4 * 3 - 5, stage.stageHeight);
		}
	}
}
import flash.accessibility.ISearchableText;
import flash.accessibility.ISimpleTextSelection;
import flash.display.DisplayObjectContainer;
import flash.events.AccelerometerEvent;
import flash.events.DRMAuthenticationCompleteEvent;
import flash.events.DRMAuthenticationErrorEvent;
import flash.events.DRMErrorEvent;
import flash.events.PressAndTapGestureEvent;
import flash.events.TransformGestureEvent;
import flash.events.UncaughtErrorEvent;
import flash.events.UncaughtErrorEvents;
import flash.geom.Rectangle;
import flash.globalization.CollatorMode;
import flash.globalization.CurrencyFormatter;
import flash.globalization.CurrencyParseResult;
import flash.globalization.DateTimeFormatter;
import flash.globalization.DateTimeNameContext;
import flash.globalization.DateTimeNameStyle;
import flash.globalization.DateTimeStyle;
import flash.globalization.LastOperationStatus;
import flash.globalization.LocaleID;
import flash.globalization.NationalDigitsType;
import flash.globalization.NumberFormatter;
import flash.globalization.NumberParseResult;
import flash.globalization.StringTools;
import flash.media.scanHardware;
import flash.net.drm.AuthenticationMethod;
import flash.net.drm.DRMContentData;
import flash.net.drm.DRMManager;
import flash.net.drm.DRMPlaybackTimeWindow;
import flash.net.drm.DRMVoucher;
import flash.net.drm.LoadVoucherSetting;
import flash.net.drm.VoucherAccessInfo;
import flash.net.GroupSpecifier;
import flash.net.NetGroup;
import flash.net.NetGroupInfo;
import flash.net.NetGroupReceiveMode;
import flash.net.NetGroupReplicationStrategy;
import flash.net.NetGroupSendMode;
import flash.net.NetGroupSendResult;
import flash.net.NetStreamMulticastInfo;
import flash.sensors.Accelerometer;
import flash.system.SystemUpdater;
import flash.system.TouchscreenType;
import flash.text.ime.CompositionAttributeRange;
import flash.text.ime.IIMEClient;
import flash.ui.KeyboardType;
import flash.ui.Multitouch;
import flash.ui.MultitouchInputMode;
import flash.utils.describeType;

const CLASSES: Array = [
	new Data(ISearchableText), 
	new Data(ISimpleTextSelection), 
	new Data(AccelerometerEvent), 
	new Data(DRMAuthenticationCompleteEvent), 
	new Data(DRMAuthenticationErrorEvent), 
	new Data(DRMErrorEvent), 
	new Data(PressAndTapGestureEvent), 
	new Data(TransformGestureEvent),
	new Data(UncaughtErrorEvent), 
	new Data(UncaughtErrorEvents),
	new Data(CollatorMode), 
	new Data(CurrencyFormatter), 
	new Data(CurrencyParseResult),
	new Data(DateTimeFormatter),
	new Data(DateTimeNameContext), 
	new Data(DateTimeNameStyle), 
	new Data(DateTimeStyle), 
	new Data(LastOperationStatus), 
	new Data(LocaleID),
	new Data(NationalDigitsType), 
	new Data(NumberFormatter),
	new Data(NumberParseResult), 
	new Data(StringTools), 
	new Data(AuthenticationMethod),
	new Data(DRMContentData),
	new Data(DRMManager), 
	new Data(DRMPlaybackTimeWindow), 
	new Data(DRMVoucher), 
	new Data(LoadVoucherSetting),
	new Data(VoucherAccessInfo), 
	new Data(GroupSpecifier), 
	new Data(NetGroup), 
	new Data(NetGroupInfo), 
	new Data(NetGroupReceiveMode), 
	new Data(NetGroupReplicationStrategy), 
	new Data(NetGroupSendMode), 
	new Data(NetGroupSendResult), 
	new Data(NetStreamMulticastInfo),
	new Data(Accelerometer), 
	new Data(SystemUpdater),
	new Data(TouchscreenType), 
	new Data(CompositionAttributeRange), 
	new Data(IIMEClient), 
	new Data(KeyboardType), 
	new Data(Multitouch),
	new Data(MultitouchInputMode),
	new Data(scanHardware)
];
class Data
{
	private var _label: String;
	private var _value: String;
	function Data(clazz: Object)
	{
		var xml: XML = describeType(clazz);
		_label = xml.@name;
		_value = xml.toString();
	}
	
	public function get label():String { return _label; }
	
	public function get value():String { return _value; }
}

//{ ResizeComp
import com.bit101.components.Component;
import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
class ResizeComp extends Sprite
{
	public static const VERTICAL: int = 1;
	public static const HORIZONTAL: int = 2;
	private var _comp: Component;
	private var _type: int = HORIZONTAL | VERTICAL;
	private var resizeHandle: Sprite;
	private var _dx: Number;
	private var _dy: Number;
	private var shadow:Shape;
	private var dragRect: Rectangle;
	private var _topSprite: Sprite;
	function ResizeComp(top: Sprite, comp: Component, type: int = 3, dx: Number = 0, dy: Number = 0)
	{
		_topSprite = top;
		addChild(_comp = comp);
		_type = type > 3 ? 3 : type;
		_dx = dx, _dy = dy;
		draw();
	}
	
	public function draw():void
	{
		_comp.draw();
		var g: Graphics;
		_topSprite.addChild(resizeHandle ||= new Sprite());
		resizeHandle.removeEventListener(MouseEvent.MOUSE_DOWN, onDown);
		resizeHandle.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
		resizeHandle.buttonMode = true;
		g = resizeHandle.graphics;
		g.clear();
		switch (_type)
		{
			case VERTICAL:
				g.beginFill(0xFFFFFF, 0.01);
				g.drawRect( -5, 0, 10, -10 );
				g.endFill();
				g.lineStyle(1, 0x777777);
				g.moveTo( -5, -1 ), g.lineTo( 5, -1 );
				g.moveTo( -5, -3 ), g.lineTo( 5, -3 );
				g.moveTo( -5, -5 ), g.lineTo( 5, -5 );
				resizeHandle.x = _comp.x + _comp.width / 2 + _dx;
				resizeHandle.y = _comp.y + _comp.height + _dy;
				dragRect = new Rectangle(resizeHandle.x, 0, 0, 2000);
			break;
			case HORIZONTAL:
				g.beginFill(0xFFFFFF, 0.01);
				g.drawRect( 0, -5, -10, 10 );
				g.endFill();
				g.lineStyle(1, 0x777777);
				g.moveTo( -1, -5 ), g.lineTo( -1, 5 );
				g.moveTo( -3, -5 ), g.lineTo( -3, 5 );
				g.moveTo( -5, -5 ), g.lineTo( -5, 5 );
				resizeHandle.x = _comp.x + _comp.width + _dx;
				resizeHandle.y = _comp.y + _comp.height / 2 + _dy;
				dragRect = new Rectangle(0, resizeHandle.y, 2000, 0);
			break;
			case HORIZONTAL | VERTICAL:
				g.beginFill(0xFFFFFF, 0.01);
				g.moveTo(   0,   0 );
				g.lineTo( -10,   0 );
				g.lineTo( -10, -10 );
				g.lineTo(   0,   0 );
				g.endFill();
				g.lineStyle(1, 0x777777);
				g.moveTo( -2, 0 ), g.lineTo( 0, -2 );
				g.moveTo( -5, 0 ), g.lineTo( 0, -5 );
				g.moveTo( -8, 0 ), g.lineTo( 0, -8 );
				resizeHandle.x = _comp.x + _comp.width + _dx;
				resizeHandle.y = _comp.y + _comp.height + _dy;
				dragRect = null;
			break;
		}
	}
	
	private function onDown(e:MouseEvent):void 
	{
		_topSprite.addChild(shadow ||= new Shape());
		resizeHandle.removeEventListener(MouseEvent.MOUSE_DOWN, onDown);
		stage.addEventListener(MouseEvent.MOUSE_MOVE, onMove);
		stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
		resizeHandle.startDrag(false, dragRect);
	}
	
	private function onUp(e:MouseEvent):void 
	{
		_topSprite.removeChild(shadow);
		stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMove);
		stage.removeEventListener(MouseEvent.MOUSE_UP, onUp);
		resizeHandle.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
		resizeHandle.stopDrag();
		var w: Number = _comp.width + (((_type & HORIZONTAL) > 0) ? 
			(resizeHandle.x - (_comp.x + _comp.width + _dx)) : 0);
		var h: Number = _comp.height + (((_type & VERTICAL) > 0) ? 
			(resizeHandle.y - (_comp.y + _comp.height + _dy)) : 0);
		_comp.setSize(w, h);
		_comp.draw();
		dispatchEvent(new Event(Event.RESIZE));
	}
	
	private function onMove(e:MouseEvent):void 
	{
		var g: Graphics = shadow.graphics;
		var dw: int = ((_type & HORIZONTAL) > 0) ? 0 : 5;
		var dh: int = ((_type & VERTICAL) > 0) ? 0 : 5;
		var w: Number = _comp.width + _dx + (((_type & HORIZONTAL) > 0) ? 
			(resizeHandle.x - (_comp.x + _comp.width +_dx)) : 0);
		var h: Number = _comp.height + _dy + (((_type & VERTICAL) > 0) ? 
			(resizeHandle.y - (_comp.y + _comp.height +_dy)) : 0);
		g.clear();
		g.beginFill(0x777777, 0.3);
		g.drawRect(_comp.x, _comp.y, w, h);
		g.drawRect(_comp.x, _comp.y, w - 5 + dw, h - 5 + dh);
	}
}
//}