/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xUgJ
 */

package {
    import flash.system.Capabilities;
    import flash.utils.setTimeout;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.utils.ByteArray;
    
    import com.actionscriptbible.Example;
    public class FlashTest extends Example {
        
        private var s:Sound;
        
        public function FlashTest() {
            trace('version: ' + Capabilities.version);
            trace('isDebugger: ' + Capabilities.isDebugger);
            s = new Sound(new URLRequest('http://www.apmmusic.com/audio/DED/DED_DED_0132/DED_DED_0132_00401.mp3'));
            s.addEventListener(Event.COMPLETE, complete);
            trace('sound loading...');
        }
        
        private function complete(e:Event):void {
            trace('done. you might hear something unpleasant.');
            s.play();
            try {
                var ba:ByteArray = new ByteArray();
                s.extract(ba, 512, 8820);
                ba.position = 0;
                trace('extract: ' + ba.readFloat());
            } catch (e:Error) {
                trace('could not extract: ' + e);
            }
            setTimeout(later, 100);
        }
        
        private function later():void {
            trace('areSoundsInaccessible: ' + SoundMixer.areSoundsInaccessible());
            try {
                var ba:ByteArray = new ByteArray();
                SoundMixer.computeSpectrum(ba);
                ba.position = 0;
                trace('computeSpectrum: ' + ba.readFloat());
            } catch (e:Error) {
                trace('could not computeSpectrum: ' + e);
            }
        }
        
    }
}