/**
 * Copyright vectorcinco ( http://wonderfl.net/user/vectorcinco )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xUWd
 */

package {
	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.net.URLRequest;
	import flash.display.BitmapData;

	public class youtubeGrid extends Sprite {
		private var loader1:Loader;
		private var player:Object;
		private var video_array:Array;
		private var count:int;
		var bg:Sprite
		public function youtubeGrid() {

			stage.align=StageAlign.TOP_LEFT;
			stage.scaleMode=StageScaleMode.NO_SCALE;

			video_array=new Array("pcEpdxsWZLA","3awbR_EzYr8","Hz86TsGx3fc","QCQTr8ZYdhg");
			count=0;

			loader1 = new Loader();
			loader1.contentLoaderInfo.addEventListener(Event.INIT, loadInit);
			loader1.load(new URLRequest("http://www.youtube.com/apiplayer?version=3"));
			addChild(loader1);
			createBg();
			stage.addEventListener(Event.RESIZE, resizeStage);


		}
		private function resizeStage(event:Event):void {
			removeChild(bg)
			createBg();
			player.setSize(stage.stageWidth, stage.stageHeight);
		}
		private function loadInit(event:Event):void {
			player=loader1.content;
			player.addEventListener("onReady", playerReady);
			player.addEventListener("onStateChange", onPlayerStateChange);

		}
		private function onPlayerStateChange(event:Event):void {
			if (Object(event).data==0) {
				nextVideo();
			}
		}

		private function playerReady(event:Event):void {
			player.setSize(stage.stageWidth, stage.stageHeight);
			player.cueVideoById(video_array[count],0,"default");
			player.playVideo();
		}
		private function nextVideo():void {
			count++;
			if (count>=video_array.length) {
				count=0;
			}
			player.cueVideoById(video_array[count],0,"default");
			player.playVideo();

		}
		public function background():BitmapData {
			return BitmapPatternBuilder.build([[0, 1],[2, 3]],[0xFFFF0000,0xff00FF00,0xff0000FF,0xff000000]);
		}
		private function createBg():void {
			var pattern:BitmapData=background();
			bg = addChild(new Sprite()) as Sprite;
			bg.graphics.beginBitmapFill(pattern);
			bg.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			bg.graphics.endFill();
			bg.blendMode="overlay";
		}

	}
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;

class BitmapPatternBuilder {
	public static function build(pattern:Array, colors:Array):BitmapData {
		var bitmapW:int=pattern[0].length;
		var bitmapH:int=pattern.length;
		var bmd:BitmapData=new BitmapData(bitmapW,bitmapH,true,0x000000);
		for (var yy:int=0; yy<bitmapH; yy++) {
			for (var xx:int=0; xx<bitmapW; xx++) {
				var color:int=colors[pattern[yy][xx]];
				bmd.setPixel32(xx, yy, color);
			}
		}
		return bmd;
	}

	public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void {
		var bmd:BitmapData=build(pattern,colors);
		graphics.beginBitmapFill(bmd);
		bmd.dispose();
	}
}