/**
 * Copyright mtok ( http://wonderfl.net/user/mtok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xUSb
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * ...
     * @author Motoki Matsumoto
     */
    public class Main extends Sprite 
    {
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            addChild(new PerlinNoiseDemo());
        }
        
    }
    
}
import com.bit101.components.CheckBox;
import com.bit101.components.Label;
import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.events.Event;
import flash.display.BitmapDataChannel;
import com.bit101.components.HSlider;
import flash.events.MouseEvent;

class PerlinNoiseDemo extends Sprite{
    private var _bmp:Bitmap;
    private var _ui:Sprite;
    private var _baseX:HSlider;
    private var _baseY:HSlider;
    private var _numOctaves:HSlider;
    private var _randomSeed:HSlider;
    private var _stitch:CheckBox;
    private var _fractal:CheckBox;
    private var _a:CheckBox;
    private var _r:CheckBox;
    private var _g:CheckBox;
    private var _b:CheckBox;
    private var _grayScale:CheckBox;
    public function PerlinNoiseDemo() {
        if (stage) {
            initialize();
        }else {
            addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
        }
    }
    
    private function addedToStageHandler(e:Event):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
        initialize();
    }
    
    private function initialize():void
    {
        addEventListener(Event.RENDER, renderHandler);
        var w:Number = stage.stageWidth;
        var h:Number = stage.stageHeight;
        _bmp = new Bitmap(new BitmapData(w, h));
        
        addChild(_bmp);
        
        _ui = new Sprite();
        _ui.graphics.beginFill(0xffffff);
        _ui.graphics.drawRect(0, 0, 180, 180);
        _ui.graphics.endFill();
        addChild(_ui);
        var label:Label;
        label = new Label(_ui, 10, 10, "base x");
        _baseX = new HSlider(_ui, 70, 10, notifyValueChanged);
        _baseX.maximum = w;
        _baseX.minimum = 1;

        label = new Label(_ui, 10, 30, "base y");
        _baseY = new HSlider(_ui, 70, 30, notifyValueChanged);
        _baseY.maximum = h;
        _baseY.minimum = 1;
        
        label = new Label(_ui, 10, 50, "numOctaves");
        _numOctaves = new HSlider(_ui, 70, 50, notifyValueChanged);
        _numOctaves.maximum = 10;
        _numOctaves.minimum = 0;
        
        label = new Label(_ui, 10, 70, "randomSeed");
        _randomSeed = new HSlider(_ui, 70, 70, notifyValueChanged);
        _randomSeed.maximum = 100;
        _randomSeed.minimum = 0;

        _stitch = new CheckBox(_ui, 70, 90, "stitch", notifyValueChanged);
        _stitch.selected = true;
        
        _fractal = new CheckBox(_ui, 70, 110, "fractal", notifyValueChanged);
        _fractal.selected = true;
        
        label = new Label(_ui, 10, 130, 'channel');
        _a = new CheckBox(_ui, 70, 130, 'A', notifyValueChanged);
        _r = new CheckBox(_ui, 90, 130, 'R', notifyValueChanged);
        _g = new CheckBox(_ui, 110, 130, 'G', notifyValueChanged);
        _b = new CheckBox(_ui, 130, 130, 'B', notifyValueChanged);
        
        _grayScale = new CheckBox(_ui, 70, 150, 'gray scale', notifyValueChanged);
        update();
        
        addEventListener(MouseEvent.CLICK, clickHandler);
    }
    
    private function clickHandler(e:MouseEvent):void 
    {
        if (e.target == this) {
            _ui.visible = !_ui.visible;
        }
    }
    
    private function renderHandler(e:Event):void 
    {
        update();
    }
    private function notifyValueChanged(e:Event):void 
    {
        if (stage) {
            stage.invalidate();
        }
    }
    private function update():void 
    {
        var baseX:int = _baseX.value;
        var baseY:int = _baseY.value;
        var numOctaves:uint = _numOctaves.value;
        var randomSeed:int = _randomSeed.value;
        var stitch:Boolean = _stitch.selected;
        var fractalNoise:Boolean = _fractal.selected;
        var channelOptions:int = getChannelOptions();
        var grayScale:Boolean = _grayScale.selected;
        var offsets:Array = [];
        
        _bmp.bitmapData.perlinNoise(
            baseX, baseY,
            numOctaves,
            randomSeed,
            stitch,
            fractalNoise,
            channelOptions,
            grayScale,
            offsets);
    }
    private function  getChannelOptions():int
    {
        var option:int = 0;
        if (_a.selected) {
            option |= BitmapDataChannel.ALPHA;
        }
        if (_r.selected) {
            option |= BitmapDataChannel.RED;
        }
        if (_g.selected) {
            option |= BitmapDataChannel.GREEN;
        }
        if ( _b.selected) {
            option |= BitmapDataChannel.BLUE;
        }
        
        return option;
    }
}