/**
 * Copyright Aksor.Al1 ( http://wonderfl.net/user/Aksor.Al1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xTy8
 */

// forked from daijimachine's Dancing Dobuemon
/**
* Dancing Dobuemon
* 
* 以前作った ↓ にメッシュアニメーションをつけてみた。
* http://wonderfl.net/c/dTAt
* せっかくなので音に合わせてダンスさせてみた。（ダンスというよりただの顔芸。）
* 
* 音は以下より拝借
* http://mutast.heteml.jp/works/music/music.mp3
* 
* ビート検知は以下を参考に、てかそのまま使わせていただきました。あたーす。
* http://wonderfl.net/c/dttt
* 
* @author Masayuki Daijima (ARCHETYP Inc.)
* http://www.daijima.jp/blog/
* http://twitter.com/daijimachine
*/

package
{
    import away3dlite.templates.FastTemplate;
    import away3dlite.loaders.Loader3D;
    import away3dlite.loaders.MD2;
    import away3dlite.animators.MovieMesh;
    import away3dlite.materials.BitmapFileMaterial;
    import away3dlite.events.MaterialEvent;
    import away3dlite.events.Loader3DEvent;

    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    
    [SWF(backgroundColor = "#000000", frameRate = "30", width = "465", height = "465")]
    
    public class Document extends FastTemplate
    {
        private var loader:Loader3D;
        private var snd:Sound;
        private var model:MovieMesh;
        private var material:BitmapFileMaterial;
        
        private var cameraX:Number;
        private var cameraY:Number;
        
        private const BMP_PATH:String = "http://www.daijima.jp/materials/wonderfl/dobuemon/modeldata/dobuemon.png";
        private const MD2_PATH:String = "http://www.daijima.jp/materials/wonderfl/dobuemon/modeldata/dobuemon2.md2";
        private const MP3_PATH:String = "http://www.daijima.jp/materials/sound/music.mp3";
        
        override protected function onInit():void
        {
            debug = false;
            material = new BitmapFileMaterial(BMP_PATH);
            material.addEventListener(MaterialEvent.LOAD_SUCCESS, onLoadMaterial);
            
            var md2:MD2 = new MD2();
            md2.material = material;
            md2.scaling = 30;
            scene.rotationX = 30;
            scene.rotationY = 90;
            scene.rotationZ = -60;
            loader = new Loader3D(); 
            loader.loadGeometry(MD2_PATH, md2);
            loader.addEventListener(Loader3DEvent.LOAD_SUCCESS, onSuccess);
            view.scene.addChild(loader);
            
            setSound();
        }
        
        private function onLoadMaterial(event:MaterialEvent):void 
        {
            event.target.removeEventListener(event.type, arguments.callee);
        }
        
        private function setSound():void
        {
            snd = new Sound();
            snd.load(new URLRequest(MP3_PATH));
            snd.addEventListener(Event.COMPLETE, onLoadSound);
        }
        
        private function onLoadSound(event:Event):void 
        {
            event.target.removeEventListener(event.type, arguments.callee);
            var channel:SoundChannel = new SoundChannel();
            channel = snd.play(0, 65535);
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(event:Event):void 
        {
            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes, false, 0);
            bytes.position = 0;
            var rf:Number;
            var count:int = 0;
            for (var q:int = 0; bytes.bytesAvailable >= 4; q++) {
                rf = bytes.readFloat();
                var t:Number = Math.abs(rf);
                if (t >= 0.4 && q >256) count ++;
                if (count >= 120) dancing();
            }
            
            camera.x += (cameraX - camera.x) / 3;
            camera.y += (cameraY - camera.y) / 3;
            camera.lookAt(scene.position);
        }
        
        private function dancing():void
        {
            express();
            cameraX = Math.random() * 1200 - 600;
            cameraY = Math.random() * 1200 - 600;
        }
        
        private function onSuccess(event:Loader3DEvent):void
        {
            event.target.removeEventListener(event.type, arguments.callee);
            model = event.loader.handle as MovieMesh;
        }
        
        private function express():void 
        {
            var rand:int = Math.floor(Math.random() * 4);
            if (rand == 0) model.play("ononoki");
            else if (rand == 1) model.play("shitari");
            else if (rand == 2) model.play("inoki");
            else model.play("hokusoemi");
        }
        
        override protected function onPreRender():void
        {
            view.render();
        }
    }
}