/**
 * Copyright yprops ( http://wonderfl.net/user/yprops )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xTaR
 */

// forked from yprops's Number型のビット確認用
// forked from yprops's DebugText
package {
    import flash.utils.ByteArray;
    import flash.display.Sprite;
    import flash.text.TextField;
    public class DebugText extends Sprite {
        public function DebugText() {
            addDeb(450, 450);
            
            //本文
            addDebLine("\n-----------------------------------\nNumber → ビット");
            outputNum2Bit(0);
            outputNum2Bit(1);
            outputNum2Bit(-1);
            outputNum2Bit(Number.NaN);
            
            addDebLine("\n-----------------------------------\nビット → Number");
            outputBit2Num("0011111111110000000000000000000000000000000000000000000000000000");
            outputBit2Num("1000000000000000000000000000000000000000000000000000000000000000");
            outputBit2Num("0111111111110000000000000000000000000000000000000000000000000000");
         }
        
        
        //----------------------------
        
        private function outputNum2Bit(n :Number) :void{
            addDebLine("\n[Number]\n" + n + "\n[bit]\n" + num2Bit(n));
        }
        private function num2Bit(n :Number) :String{
            var b :ByteArray = new ByteArray();
            b.writeDouble(n);
            b.position = 0;
            var s :String = int2Bit(b.readInt()) + int2Bit(b.readInt());
            return "符号: " + s.slice(0,1) + 
                   "\n指数: " + s.slice(1,12) + 
                   "\n仮数: " + s.slice(12);
        }
        private function int2Bit(n :int) :String{
            var i :int;
            var s :String = "";
            for(i = 0; i < 32; i++){
                s = ((n & 1 << i)? "1" : "0") + s;
            }
            return s;
        }
        
        private function outputBit2Num(t :String) :void{
            var n :Number = bit2Num(t);
            addDebLine("\n[bit]\n" + num2Bit(n) + "\n[Number]\n" + n);
        }
        /// @param t 01010...といった文字列。右から64文字を使用。1をtrue、他を false としてNumberに変換。
        private function bit2Num(t :String) :Number{
            var i :int;
            var n :Number = 0;
            var b :ByteArray = new ByteArray();
            //addDebLine(t + " " + t.slice(-32));
            b.writeInt(bit2Int(t.slice(-64, -32)));
            b.writeInt(bit2Int(t.slice(-32)));
            b.position = 0;
            return b.readDouble();
        }
        private function bit2Int(t :String) :int{
            var i :int;
            var n :int = 0;
            for(i = 0; i < 64; i++){
                n |= int(t.charAt(t.length - 1 - i) == "1") << i;
            }
            return n;
        }
        
        
        //-------------------------------
        private var deb :TextField;
        private function addDeb(w:uint, h:uint) :void{
                deb = new TextField();
                deb.wordWrap = true;
                deb.width = w;
                deb.height = h;
                deb.border = true;
                deb.borderColor = 0;
                deb.background = true;
                deb.backgroundColor = 0x99ffffff;
                deb.text = "beginDebugText-------\n";
                addChild(deb);
        }
        private function addDebLine(str :String) :void{
                deb.appendText(str + "\n");
                deb.scrollV = deb.maxScrollV;
        }
    }
}