/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xTND
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.filters.*;
    import flash.text.*;
    import flash.geom.*;
    
    public class FlashTest extends Sprite {
        private var _pic : String = "";
        
        private var _orig : BitmapData;
        private var _bmd : BitmapData;
        private var _t : Number;
        private var _step : Number;
        
        private var _tf : TextField;
        
        public function FlashTest() {
            _orig = drawText("鬱", 100, 3);
            
            _bmd = _orig.clone();
            var bmp : Bitmap = new Bitmap(_bmd);
            addChild(bmp);
            
            _t = 0.01;
            _step = 0.1;
            
            _tf = new TextField();
            addChild(_tf);
            _tf.x = 300;
            _tf.width = 150;
            _tf.height = 450;
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e : Event) : void
        {
            _t += _step;
            if(Math.abs(_t) > 1.2){
                _step = -_step;
            }
            if(Math.abs(_t) > 0.01){
                var dis : BitmapFilter = makeDisFilter(_bmd.width, _bmd.height, _t);
                _bmd.applyFilter(_orig, _orig.rect, new Point(), dis);
            }
        }
        
        private function makeDisFilter(w : int, h : int, theta : Number) : BitmapFilter
        {
                        var r : Number = h / (2 * Math.abs(theta));
            var trans : BitmapData = new BitmapData(w, h, false);
            for(var j : int = 0;j < h;j++){
                var yy : int = h - j;
                var c : Number = Math.cos(yy / r);
                var s : Number = Math.sin(yy / r);
                for(var i : int = 0;i < w;i++){
                    var xx : int = i - int(w / 2);
                    if(theta > 0)xx = -xx;
                    var dx : Number = (-r + (r + xx) * c) - xx;
                    if(theta > 0)dx = -dx;
                    var dy : Number = (r + xx) * s - yy;
                    dx *= 0.38;
                    dy *= 0.38;
                    trans.setPixel(i, j, (128 << 16) | ((128 + int(dx)) << 8) | (128 + int(dy)));
                }
            }
//            var ddd : Bitmap = new Bitmap(trans);
//            addChild(ddd);
            return new DisplacementMapFilter(trans, new Point(), 2, 4, 200, 200, "clamp");
        }
        
        private function drawText(text : String, size : Number, scale : Number) : BitmapData
        {
            var tf : TextField = new TextField();
            tf.defaultTextFormat = new TextFormat("arial", size);
            tf.autoSize = "left";
            tf.appendText(text);
            var recter : BitmapData = new BitmapData(tf.width * scale, tf.height * scale, true);
            recter.draw(tf, new Matrix(scale, 0, 0, scale, -2, -2));
            
            var rect : Rectangle = recter.getColorBoundsRect(0xffffff, 0x000000, true);
            var ret : BitmapData = new BitmapData(rect.width + 2, rect.height + 2, true);
            ret.draw(recter, new Matrix(1, 0, 0, 1, -rect.x + 1, -rect.y + 1));
                
            recter.dispose();
            return ret;
        }
    }
}