/**
 * Copyright zier ( http://wonderfl.net/user/zier )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xRif
 */

package {
    // 使い方は onKeyDown() を見てください
    // usage sees 'onKeyDown()'
    
    import flash.display.Sprite;
    import flash.events.Event
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import org.papervision3d.core.math.Matrix3D;
    import org.papervision3d.core.math.Number3D;

    // Papervision3D 
    import org.papervision3d.view.BasicView
    import org.papervision3d.lights.*
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.shadematerials.*
    import org.papervision3d.objects.primitives.*

    // tweener
    import caurina.transitions.*

    [SWF(width="400", height="400", backgroundColor='0x4e616b', frameRate="60")]
    public class Main extends BasicView {
        private const DEGREE_TO_RADIAN: Number = Math.PI / 180
        private const DEFAULT_TIME: Number = 2.5
        private const DEFAULT_TRANSITION: String = "easeOutElastic" // "easeOutBack"
        
        private var model: Cube = null
        private var direction: Number3D = new Number3D()
        
        private var light:PointLight3D = new PointLight3D()
        private var white: FlatShadeMaterial = new FlatShadeMaterial(light, 0xFFFFFF, 0xFFFFFF)
        private var blue: FlatShadeMaterial = new FlatShadeMaterial(light, 0x0000FF, 0x0000FF)
        private var green: FlatShadeMaterial = new FlatShadeMaterial(light, 0x00FF00, 0x00FF00)
        private var red: FlatShadeMaterial = new FlatShadeMaterial(light, 0xFF0000, 0xFF0000)
        private var yellow: FlatShadeMaterial = new FlatShadeMaterial(light, 0xFFFF00, 0xFFFF00)
        private var orange: FlatShadeMaterial = new FlatShadeMaterial(light, 0xFF8000, 0xFF8000)
        private var black: FlatShadeMaterial = new FlatShadeMaterial(light, 0x000000, 0x000000)
        
        private function createCube(size: int): Cube {
            var list: MaterialsList = new MaterialsList()
            list.addMaterial(red, "front")
            list.addMaterial(white, "top")
            list.addMaterial(green, "right")
            list.addMaterial(yellow, "left")
            list.addMaterial(blue, "bottom")
            list.addMaterial(orange, "back")
            return new Cube(list, size, size, size, 1, 1, 1, 0, 0)
        }
        
        public function Main() {
            model = createCube(500)
            scene.addChild(model)
            
            startRendering()
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown)
            
            tweenCamera(-1, +1);
            tweenModel(4, 4, 0, 5);
        }
        
        private function tweenCamera(dx: int, dy: int, _t: Number = DEFAULT_TIME): void {
            var _r: Number = (180 + dx * 25) * DEGREE_TO_RADIAN
            var _y: Number = 400 * dy
            
            Tweener.addTween(camera, { x: 1000 * Math.sin(_r), time: _t, transition: DEFAULT_TRANSITION } );
            Tweener.addTween(camera, { z: 1000 * Math.cos(_r), time: _t, transition: DEFAULT_TRANSITION } );
            Tweener.addTween(camera, { y: _y, time: _t, transition: DEFAULT_TRANSITION } );
        }
        
        private function tweenModelMain(v: Number3D, _t: int): void {
            Tweener.addTween(model, { rotationX: v.x, time: _t, transition: DEFAULT_TRANSITION } );
            Tweener.addTween(model, { rotationY: v.y, time: _t, transition: DEFAULT_TRANSITION } );
            Tweener.addTween(model, { rotationZ: v.z, time: _t, transition: DEFAULT_TRANSITION } );
        }
        
        private function tweenModel(dx: int, dy: int, dz: int, _t: Number = DEFAULT_TIME): void {
            /* problem
             * 今はモデルの向きを考慮した方向転換ができていないため、この部分は課題である。
             * カメラから見えている面に対して直感的な方向転換操作ができれば良い
             */
            direction = new Number3D(direction.x + dx * 90, direction.y + dy * 90, direction.z + dz * 90)
            tweenModelMain(direction, _t)
        }
        
        private function reset(_t: Number = DEFAULT_TIME): void {
            direction = Number3D.ZERO
            tweenModelMain(direction, _t)
        }
        
        private function onKeyDown(e: KeyboardEvent): void {
            switch (e.keyCode) {
            // cursor
            case 37: break // left
            case 38: break // up
            case 39: break // right
            case 40: break // down
            
            // camera control
            case 32: tweenCamera(0, 0); break   // Space
            case 81: tweenCamera(+1, +1); break // Q 
            case 69: tweenCamera(-1, +1); break // E
            case 90: tweenCamera(+1, -1); break // Z
            case 67: tweenCamera(-1, -1); break // C
            
            // model control
            case 82: reset(); break              // R Reset
            case 87: tweenModel(-1, 0, 0); break // W X-
            case 65: tweenModel(0, -1, 0); break // A Y-
            case 83: tweenModel(0, -2, 0); break // S reverse
            case 68: tweenModel(0, +1, 0); break // D Y+
            case 88: tweenModel(+1, 0, 0); break // X X+
            case 70: tweenModel(0, 0, -1); break // F Z-
            case 71: tweenModel(0, 0, +1); break // G Z+
            }
        }
    }
}