/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xR53
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.Matrix;
    
    import flash.events.MouseEvent;
    
    [SWF(width = "465", height = "465")]
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        
        private var _canvas:BitmapData;
        private var _canvasbmp:Bitmap;
        private var _pcanvas:BitmapData;
        
            
        private var _particles:Vector.<Particle>;
        
        private var stagein:Boolean = true;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            graphics.beginFill(0);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();
            
            _canvasbmp = new Bitmap();
            addChild( _canvasbmp );            
            
            Reset();
            
            addEventListener(Event.ENTER_FRAME, Update);
        }
        
        private function Reset() : void
        {
            if ( _canvas )    _canvas.dispose();
            _canvas = new BitmapData( WIDTH, HEIGHT, true, 0 );
            _canvasbmp.bitmapData = _canvas;
            
            _pcanvas = new BitmapData( WIDTH, HEIGHT, true, 0 );
            
            _particles = new Vector.<Particle>( PARTICLE_NUM, true );
            
            var i:int;
            var p:Particle;
            for ( i = 0; i < PARTICLE_NUM; i++ )
            {
                var anglerad:Number = Math.random() * PI2;
                var vx:Number = Math.cos( anglerad ) * 3;
                var vy:Number = Math.sin( anglerad ) * 3;
                p = new Particle( Math.random() * WIDTH, Math.random() * HEIGHT, vx, vy );    
                _particles[i] = p;
            }
            for ( i = 0; i < PARTICLE_NUM; i++ )
            {
                p = _particles[i];
                p.target = _particles[int(Math.random() * PARTICLE_NUM)];
            }
        }
        
        private function Update(e:Event) : void
        {
            var i:int;
            var p:Particle, t:Particle;
                        
            _pcanvas.lock();
            _pcanvas.fillRect( _pcanvas.rect, 0xFF000000 );
            for ( i = 0; i < PARTICLE_NUM; i++ )
            {
                p = _particles[i];
                t = _particles[i].target;
            
                p.vx = p.vx + ((p.x - t.x)+0.01) / 5000;
                p.vy = p.vy + ((p.y - t.y)-0.01) / 10000;
                p.x += p.vx;
                p.y += p.vy;
                
                var sp:Number = Math.sqrt( (p.vx * p.vx) + (p.vy * p.vy) )
                if ( sp > 5 )
                {
                    p.vx /= sp * 5;
                    p.vy /= sp * 5;
                }
                
                if ( p.x < 0 )    p.x = WIDTH - (p.x % WIDTH);
                else if ( p.x >= WIDTH ) p.x = p.x % WIDTH;
                if ( p.y < 0 ) p.y = HEIGHT - (p.y % HEIGHT);
                else if ( p.y >= HEIGHT ) p.y = p.y % HEIGHT;
                
                _canvas.setPixel32( p.x, p.y, p.color );
                _canvas.setPixel32( p.x+1, p.y, p.color );
            }
            _pcanvas.unlock();
            
            _canvas.applyFilter( _canvas, _canvas.rect, new Point(), new BlurFilter(8,8,2) );
            _canvas.draw( _pcanvas, null, null, "add");
        }    
    }
    
}
import flash.display.BitmapData;


const PI2:Number = 3.141592653589793 * 2;
const WIDTH:int = 465;
const HEIGHT:int = 465;
const PARTICLE_NUM:int = 1500;

class Particle {
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    
    public var target:Particle;
    
    public var color:uint;
    
    public function Particle(x:Number, y:Number, vx:Number, vy:Number) {
        this.x = x;
        this.y = y;
        this.vx = vx;
        this.vy = vy;        
        color = 0xFFFFFFFF;
    }
}

