/**
 * Copyright videometrist ( http://wonderfl.net/user/videometrist )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xQUQ
 */

// forked from yd_niku's flash on 2009-9-9
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.system.*;

    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.easing.*;
    
    [SWF( backgroundColor=0xFFFFFF, frameRate=30)]
    public class Ginny extends Sprite {
        
        private var _points:Vector.<Point> = new Vector.<Point>;
        private var _vertex:Vector.<Number> = new Vector.<Number>;
        private var _indices:Vector.<int> = new Vector.<int>;
        private var _uv:Vector.<Number> = new Vector.<Number>;
        private var _col:int = 12;
        private var _row:int = 12;
		private static const READY :String = "ready";
        private var _contents:Bitmap;
		private var _canvas:Sprite = new Sprite();
		private var _tween:ITween;
        private var _isConvergencing:Boolean = false;
		private var picw:Number = 386;
		private var pich:Number = 366;
		private var diag:Number = Math.sqrt((picw * picw) + (pich * pich));
		 
		
		public function Ginny() {
            init();
            addEventListener( READY, atReady );
            loadImage();
        }
		
        
        private function init():void{
            var edgeW:int = _col -1;
            var edgeH:int = _row-1;
            
            var pW:Number= picw / edgeW;
            var pH:Number= pich  /edgeH;
            
            var p:Point;
            for( var py:int=0; py<_row; ++py ) {
                for( var px:int=0; px<_col; ++px ) {
                    p = new Point( px*pW, py*pH );
                    _points.push( p)
                    _vertex.push( p.x, p.y );
                    _uv.push( px/edgeW, py/edgeH);
                }
            }
            
            var uvW:Number = 1/edgeW;
            var uvH:Number = 1/edgeH;
            
            for( var h:int=0; h<edgeH; ++h ) {
                for( var w:int=0; w<edgeW; ++w ) {
                    var cell:int = h*edgeH + w;
                    
                    var a:int = cell + h;
                    var b:int = a+1;
                    var c:int = a+_col;
                    var d:int = a+_col+1;
                    
                    _indices.push( a, b, d,  a, c, d );
                }
            }
        }
        
        
        private function atReady (e:Event ):void {
            addChild( _canvas );
            drawImage();
            stage.addEventListener( MouseEvent.CLICK, click );
        }
        
        
        private function click(e:MouseEvent):void{
            _isConvergencing = !_isConvergencing;
            var clickPoint:Point = new Point( mouseX, mouseY );
            if ( _isConvergencing ) {
                var tweens:Array = [];
                var p:Point;
                for( var i :int =0; i<_points.length; ++i ) {
                    p = _points[i];
                    
                    var dx:Number = clickPoint.x - p.x;
                    var dy:Number = clickPoint.y - p.y;
                    
                    var length:Number = Math.sqrt( dx*dx + dy*dy );
                    var percent:Number = length / 1000;
                    //tweens.push( BetweenAS3.delay( BetweenAS3.to( p, { x:clickPoint.x, y:clickPoint.y }, percent * percent * 0.2 + 0.5, Cubic.easeIn ), length * 0.001 ) )
                    //tweens.push( BetweenAS3.delay( BetweenAS3.to( p, { x:clickPoint.x, y:clickPoint.y },0.5, Cubic.easeIn ), length * 0.0005 ) );
                    tweens.push( BetweenAS3.delay( BetweenAS3.to( p, { x:clickPoint.x, y:clickPoint.y },0.5, Cubic.easeIn ), (Math.cos(length/diag)*0.7)/3 ) );
					
                }
                _tween = BetweenAS3.parallelTweens( tweens );
            }
            else {
                _tween.stop();
                _tween = BetweenAS3.reverse( _tween );
            }
            
            _tween.play();
            addEventListener( Event.ENTER_FRAME, loop );
            
        }
        
        
        private function loop( e:Event ):void {
            for( var i :int =0; i<_points.length; ++i ) {
                var p:Point = _points[i];
                _vertex[ i*2 ] = p.x;
                _vertex[ i*2 +1 ] = p.y;
            }
            
            _canvas.graphics.clear();
            drawImage();
            //drawWireframe();
          
        }
        
        private function drawImage():void {
            _canvas.graphics.beginBitmapFill(_contents.bitmapData); 
            _canvas.graphics.drawTriangles( _vertex, _indices, _uv );
            _canvas.graphics.endFill();
        }
        
        
        private function drawWireframe():void {
            var paths:Vector.<IGraphicsData> = new Vector.<IGraphicsData>();
            
            var length:int = _indices.length; 
            for( var i:int = 0; i<length; i+=6  ) {
                var p0:Point = _points[ _indices[i] ];    //a
                var p1:Point = _points[ _indices[i+1] ];//b
                var p2:Point = _points[ _indices[i+4] ];//c
                var p3:Point = _points[ _indices[i+2] ];//d
                var command:GraphicsPath = new GraphicsPath();
                command.moveTo( p0.x, p0.y );
                command.lineTo( p1.x, p1.y );
                command.lineTo( p3.x, p3.y );
                command.lineTo( p0.x, p0.y );
                command.lineTo( p2.x, p2.y );
                command.lineTo( p3.x, p3.y );
                paths.push( command );
            }
            _canvas.graphics.lineStyle( 1, 0xFFFFFF );
            _canvas.graphics.drawGraphicsData(paths);
        }
        
       
        private function loadImage():void {
            var req:URLRequest = new URLRequest( "http://assets.wonderfl.net/images/related_images/2/27/2742/2742e83a7b09bd630cc5005b4d59e6ffa21accc4m" );
           var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener( Event.COMPLETE, onComplete );
            loader.load( req, new LoaderContext(true) );
        }
		
        private function onComplete( e:Event ):void {
            var loader:Loader = LoaderInfo(e.target).loader;
            _contents = loader.content as Bitmap;
            //addChild( _contents );
            dispatchEvent( new Event( READY ) )
        }
    }
}