/**
 * Copyright memo ( http://wonderfl.net/user/memo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xQ9Y
 */

package {
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    
    public class ThrowCalculator extends Sprite {
        private var throwRatio:TextField;
        private var distance:TextField;
        private var imageWidth:TextField;
        
        public function ThrowCalculator() {
            throwRatio   = make(40, 50, 2, "Throw Ratio", "=", onRatioUpdate);
            distance     = make(170, 50, 6, "Distance", "/", onDistanceUpdate);
            imageWidth  = make(300, 50, 3, "Image Width", null, onWidthUpdate);
        }
        
        private function make(tx:int, ty:int, def:Number, title:String, after:String, onClick:Function):TextField {
            // create container sprite
            var mom:Sprite = new Sprite();
            mom.x = tx;
            mom.y = ty;
            addChild(mom);
            
            // create label
            var label:TextField = new TextField();
            label.width = 100;
            label.height = 20;
            label.text = title;
            label.selectable = false;
            mom.addChild(label);
            
            // create input
            var input:TextField = new TextField();
            input.type = TextFieldType.INPUT;
            input.y = 20;
            input.width = 100;
            input.height = 20;
            input.text = String(def);
            input.border = true;
            mom.addChild(input);
            

            // create button
            var button:TextField = new TextField();
            button.y = 40;
            button.background = true;
            button.backgroundColor = 0xFF8080;
            button.border = true;
            button.height = 20;
            button.text = "CALCULATE";
            button.selectable = false;
            mom.addChild(button);
            
            button.addEventListener(MouseEvent.CLICK, onClick);
            
            if(after != null) {
                var op:TextField = new TextField();
                op.x = 110;
                op.text = after;
                op.selectable = false;
                mom.addChild(op);
            }

            return input;
        }
        
        private function onRatioUpdate(e:MouseEvent):void {
            throwRatio.text = String(parseFloat(distance.text) / parseFloat(imageWidth.text));
        }

        private function onDistanceUpdate(e:MouseEvent):void {
            distance.text = String(parseFloat(throwRatio.text) * parseFloat(imageWidth.text));
        }

        private function onWidthUpdate(e:MouseEvent):void {
            imageWidth.text = String(parseFloat(distance.text) / parseFloat(throwRatio.text));
        }

            
    }
}