/**
 * Copyright Aksor.Al1 ( http://wonderfl.net/user/Aksor.Al1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xQ0s
 */

package{
 
    import flash.display.*
 
    public class EjemploShaders extends MovieClip{
 
        import flash.display.Sprite;
        import flash.events.Event;
        import flash.display.BitmapData;
 
        import org.papervision3d.cameras.Camera3D;
        import org.papervision3d.lights.PointLight3D;
        import org.papervision3d.view.Viewport3D;
        import org.papervision3d.cameras.Camera3D;
        import org.papervision3d.scenes.Scene3D;
        import org.papervision3d.render.BasicRenderEngine;
        import org.papervision3d.materials.shaders.*;
        import org.papervision3d.materials.shadematerials.*;
        import org.papervision3d.materials.BitmapMaterial;
        import org.papervision3d.objects.primitives.Sphere;
 
        var escena:Scene3D;
        var renderer:BasicRenderEngine;
        var camara:Camera3D;
        var viewport:Viewport3D;
 
        var esfera:Sphere;
        var luz:PointLight3D;
 
        public function EjemploShaders(){
            init();
        }
 
        public function init():void{
            escena = new Scene3D();
            renderer = new BasicRenderEngine();
            camara = new Camera3D();
            viewport = new Viewport3D(400,400);
            addChild(viewport);
            camara.z = -500;
 
            //Creo un BitmapData a partir de una imagen que tengo linkaad en la biblioteca con el nombre de materialBiblioteca
 
            //Creo un BitmapMaterial con el objeto anterior
 
            //Para crear ShadedMaterials necesitamos:
            // 1. Una Luz, en este caso "luz"
            // 2. Un Shader, en este caso cualquiera de los materiales "shader", ya sea FlatShader, CellShader...
            // 3. Un ShadedMaterial, creado a partir del Shader y un BitmapData.
 
            //1. La luz
            luz = new PointLight3D;
            luz.z = -1000000;
            luz.x = 1500000;
            escena.addChild(luz);
 
            //2. Los Shader. Para probarlos basta con comentar/descomentar las lineas
            //var shader:FlatShader = new FlatShader(luz,0xffffff,0x222222);
            //var shader:CellShader = new CellShader(luz,0xffffff,0x222222);
            var shader:GouraudShader = new GouraudShader(luz,0xffffff,0x222222);
            //var shader:PhongShader = new PhongShader(luz,0xffffff,0x222222);
 
            //3. El ShadedMaterial
            //Creo la esfera con el ShadedMaterial
            escena.addChild(esfera);
 
            addEventListener(Event.ENTER_FRAME, renderizar);
        }
 
        private function renderizar(e:Event):void{
            esfera.yaw(1);    
            renderer.renderScene(escena, camara, viewport);
        }
    }
}