/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xPFu
 */

// forked from tsu_droid's forked from: sound.extract()
// forked from matacat's sound.extract()

package{
    
    //import com.bit101.components.*;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.media.*;
    import flash.net.*;
    import flash.text.*;
    import flash.utils.*;
    
    public class SoundExtract_02 extends Sprite {
        
        private const mp3URL:String = "http://www.takasumi-nagai.com/soundfiles/sound001.mp3";
         
        private const stageW:int  = stage.stageWidth;
        private const stageH:int  = stage.stageHeight >> 2;
        private const CL:int = stageH;
        private const CR:int = stageH * 3;
 
        private var sound:Sound = new Sound();
        private var sndch:SoundChannel;
 
        private var waveL:Vector.<Number>;
        private var waveR:Vector.<Number>;
        private var length:uint;
 
        private var disp:BitmapData = new BitmapData(stageW, stageH << 2, false);
        private var rect:Rectangle  = new Rectangle(0, 0, 1, 0);
        private var scale:int= 441;
 
        public function SoundExtract_02():void {
            
            sound.addEventListener(Event.COMPLETE, 
                function(evt:Event):void {
                    playSound();
                }
            );
     
             sound.load(new URLRequest(mp3URL), new SoundLoaderContext(1000, true));
        }
 
        private function playSound():void {
            initDisp();
            initTable();
         
            sndch = sound.play();
            sndch.addEventListener(Event.SOUND_COMPLETE, onSoundComplete);
     
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
 
 
        private function initDisp():void {
        
            /*
             var hSlider:HSlider = new HSlider(this, 0, 0,
                function():void{
                    scale  = 441;
                    labelObj.text = "1 : " + scale;
                }
            );
        
            hSlider.minimum = 1;
            hSlider.maximum = 441;
            hSlider.tick    = 1;
            hSlider.width   = (441 - 1) * 1 + 10;
     
            var labelObj:Label = new Label(this, 0, hSlider.height, "1 : 1");
            */
           
     
            graphics.lineStyle(3, 0x000080, 0.5);
            graphics.moveTo(stageW >> 1, 0);
            graphics.lineTo(stageW >> 1, stageH << 2);
     
            stage.addChildAt(new Bitmap(disp), 0);
        }
 
 
        private function initTable():void {
            var bytes:ByteArray = new ByteArray();
            sound.extract(bytes, sound.length * 44.1);
     
            length = bytes.length >> 3;
            waveL  = new Vector.<Number>(length, true);
            waveR  = new Vector.<Number>(length, true);
     
            bytes.position = 0;
            for (var ii:int = 0; ii < length; ii++) {
                waveL[ii] = bytes.readFloat();
                waveR[ii] = bytes.readFloat();
            }
        }
 
 
        private function onSoundComplete(e:Event):void {
            sndch.removeEventListener(Event.SOUND_COMPLETE, onSoundComplete);
            sndch = sound.play();
            sndch.addEventListener(Event.SOUND_COMPLETE, onSoundComplete);
        }
 
 
        private function onEnterFrame(e:Event):void {
            disp.lock();
            disp.fillRect(disp.rect, 0xffffff);
     
            var chPo:Number = sndch.position * 44.1 - (scale * stageW >> 1);
     
            for (var ii:int = 0; ii < stageW; ii++, chPo += scale) {
                var uL:Number = -1,
                dL:Number =  1,
                uR:Number = -1,
                dR:Number =  1,
                nn:Number;
  
                for (var jj:int = 0; jj < scale; jj++) {
                    var kk:int = chPo + jj;
      
                    if (kk >= 0 && kk < length) {
                        nn = waveL[kk];
                        if (nn > uL) uL = nn;
                        if (nn < dL) dL = nn;
   
                        nn = waveR[kk];
                        if (nn > uR) uR = nn;
                        if (nn < dR) dR = nn;
   
                    } else {
                        uL = uR = dL = dR = 0;
                    }
                }
  
                rect.x = ii;
  
                uL = uL * stageH + CL;
                dL = dL * stageH + CL;
                nn  = uL - dL;
        
                if (nn < 2) {
                      disp.setPixel(ii, uL, 0x669900);
                } else {
                    rect.y = dL;
                    rect.height = nn;
                    disp.fillRect(rect, 0x669900);
                }
  
                uR = uR * stageH + CR;
                dR = dR * stageH + CR;
                nn  = uR - dR;
        
                if (nn < 2) {
                    disp.setPixel(ii, uR, 0xCC6600);
                } else {
                    rect.y = dR;
                    rect.height = nn;
                    disp.fillRect(rect, 0xCC6600);
                }
            }
     
            disp.unlock();
        }
 
    }
}
