/**
 * Copyright syunki ( http://wonderfl.net/user/syunki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xPBc
 */

// forked from syunki's Round
// 式を立てられず、微調整したため、非常に処理のしかたが汚いです。

package 
{
	import flash.display.DisplayObject;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;

         [SWF(width = 465, height = 465, frameRate="30", backgroundColor=0xFFFFFF)]
	
	public class Round extends Sprite 
	{
		public const WIDTH:Number = 465;
		public const HEIGH:Number = 465;
		public const DISTA:Number = 125;
		
		private var _round:Array;
		private var siz:Array;
		private var container:Sprite;
		private var title:TextField;
		private var over:int;
		
		public function Round():void 
		{
			init();
		}
		
		private function init():void 
		{
			container = new Sprite();
			addChild(container);
			
			_round = [];
			siz = [];
			
			over = -1;

			title = new TextField();
			title.text = "round";
			container.addChild( title );
			
			for (var i:int = 0; i < 10; i++) {
				var round:Sprite = new Sprite();
				
				siz[i] = 10;
				_round[i] = round;
				_round[i].name = i;

				Draw(i);
				container.addChild(_round[i]);
				
				this._round[i].addEventListener(MouseEvent.MOUSE_OVER, mouseoverHandler);
				this._round[i].addEventListener(MouseEvent.MOUSE_OUT, mouseoutHandler);
			}
			this.stage.addEventListener(Event.ENTER_FRAME, eventframeHandler);
		}
		
		private function eventframeHandler(e:Event):void {
			for (var i:int =  0; i < 10; i++) {
				Draw(i);
			}
		}
		
		private function Draw(i:int):void {
			var s:Array = [ 0, 4, 3, 2, 1, 0, -1, -2, -3, -4, 0 ];
			_round[i].graphics.clear();
			_round[i].graphics.beginFill(0xFFFFFF - i * 0x000011);
			_round[i].graphics.lineStyle(2, 0x000000);
			if (over == -1) {
				_round[i].graphics.drawCircle(WIDTH / 2 + DISTA * Math.cos(i * Math.PI / 5), HEIGH / 2 + DISTA * Math.sin(i * Math.PI / 5), DISTA * Math.PI / 10 - 1);
			} else {
				if (siz[i] == 1) {
					_round[i].graphics.drawCircle(WIDTH / 2 + DISTA * Math.cos(i * Math.PI / 5) * 1.1,HEIGH / 2 + DISTA * Math.sin(i * Math.PI / 5) * 1.1, DISTA * Math.PI * 2 / 11 - 1);
				} else {
					_round[i].graphics.drawCircle(WIDTH / 2 + DISTA * Math.cos(i * Math.PI / 5 + (s[((10 - over + i) % 10)] / 20)),
													HEIGH / 2 + DISTA * Math.sin(i * Math.PI / 5 + (s[((10 - over + i) % 10)] / 20)),
													DISTA * Math.PI / 11 - 1);					
				}
			}
			_round[i].graphics.endFill();
		}
		
		private function mouseoverHandler(e:MouseEvent):void {
			if (e.currentTarget.name != 9) container.swapChildrenAt(int(e.currentTarget.name) + 1, 10);
			siz[e.currentTarget.name] = 1;
			over = e.currentTarget.name;
		}
		
		private function mouseoutHandler(e:MouseEvent):void {
			siz[e.currentTarget.name] = 0;
			if (e.currentTarget.name != 9) container.swapChildrenAt(10, int(e.currentTarget.name) + 1);
			over = -1;
		}
		
	}
}
