/**
 * Copyright yo0_0oy ( http://wonderfl.net/user/yo0_0oy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xPB9
 */

package  
{
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.geom.PerspectiveProjection;
	import flash.ui.Keyboard;
	
	[SWF(width=600, height=600,backgroundColor=0x0)]
	/**
	 * ...
	 * @author DefaultUser (Tools -> Custom Arguments...)
	 */
	public class PerspectiveProjectionTest extends Sprite
	{
		
		public function PerspectiveProjectionTest() 
		{
			transform.perspectiveProjection = new PerspectiveProjection();
			for (var i:uint = 0; i < 20; i) {
				var color:uint = Math.random() * 0xffff;
				for (var j:uint = 0; j < 4; j++ ) {
					var x:uint = (j == 0 || j == 1)?400:0;
					var y:uint = (j == 1 || j == 2)?400:0;
					createPlane(color, x , y, (20 - i) * 500);
				}
				setVanishingPoint(stage.mouseX, stage.mouseY);
				stage.addEventListener(MouseEvent.MOUSE_MOVE, onStageMouseMove);
				stage.addEventListener(KeyboardEvent.KEY_DOWN, onStageKeyDown);
			}
		}
		
		private function onStageKeyDown(e:KeyboardEvent):void 
		{
			var projection:PerspectiveProjection = transform.perspectiveProjection;
			var fieldOfView:Number = projection.fieldOfView;
			switch(e.keyCode) {
				case Keyboard.UP:
					fieldOfView += 2;
					break;
				case Keyboard.DOWN:
					fieldOfView -= 2;
					break;
			}
			projection.fieldOfView = Math.max(0.1, Math.min(fieldOfView, 179.9));
			e.updateAfterEvent();
		}
		
		private function onStageMouseMove(e:MouseEvent):void 
		{
			setVanishingPoint(stage.mouseX, stage.mouseY);
			e.updateAfterEvent();
		}
				
		private function createPlane(color:uint, x:Number,y:Number,z:Number):void
		{
			var plane:Shape = new Shape();
			plane.graphics.beginFill(color);
			plane.graphics.drawRect(0, 0, 200, 200);
			plane.graphics.drawRect(20, 20, 160, 160);
			plane.graphics.endFill();
			plane.x = x;
			plane.y = y;
			plane.z = z;
			addChild(plane);
		}
		
		private function setVanishingPoint(x:Number,y:Number):void
		{
			transform.perspectiveProjection.projectionCenter = new Point(x, y);
			graphics.clear();
			graphics.lineStyle(0, 0x666666);
			graphics.lineTo(x, y);
			graphics.lineStyle(stage.stageWidth, 0);
			graphics.lineTo(x, y);
			graphics.lineStyle(stage.stageWidth, stage.stageHeight);
			graphics.lineTo(x, y);
			graphics.lineStyle(0, stage.stageHeight);
			graphics.lineTo(x, y);
		}

	}
	
}