/**
 * Copyright marcsali ( http://wonderfl.net/user/marcsali )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xOZf
 */

package  
{
     import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Graphics;
    import flash.text.TextField;
    import flash.text.TextFormat;
    /**
     * ...
     * @author Jeet Chauhan
     */
    public class TicTacToe extends Sprite 
    {
        private var crossTurn:Boolean = true;
        private var rects:Vector.<Rect>;
        var currentMove:Number = 0;
        public function TicTacToe() 
        {
            createBoard();
        }


        private function createBoard():void 
        {
            var g:flash.display.Graphics = this.graphics;
            g.lineStyle(2, 0x000000);
            g.beginFill(0xffff00);
            g.drawRect(10, 10, 190, 190);
            rects = new Vector.<Rect>();
            var r:Rect
            for (var i:int = 0; i < 9; i++) 
            {
                r = new Rect();
                this.addChild(r);
                r.id = i;
                r.y = 20 + Math.floor(i % 3) * 60;
                r.x = 20 + Math.floor(i / 3) * 60;
                r.addEventListener(MouseEvent.CLICK, moveNextTurn);
                rects.push(r);
            }
        }

        private function moveNextTurn(e:MouseEvent):void 
        {
            var target:Rect = e.target as Rect
            target.removeEventListener(MouseEvent.CLICK, moveNextTurn);
            var turn:Sprite;
            if (crossTurn) {
                turn = target.addChild(new Cross) as Sprite;
                target.occupied = "X";
            } else {
                turn = target.addChild(new Circle) as Sprite;
                target.occupied = "O";
            }
            turn.x = 15;
            turn.y = 15;
            currentMove++;
            if (currentMove > 4) checkAnswer();
            crossTurn = !crossTurn;
        }

        private function checkAnswer():void 
        {
            var winner:String = "_";
            for (var i:int = 0, j = 0; i < 9; i += 3, j++)
            {
                if ((rects[i].occupied != "_") && (rects[i].occupied == rects[i+1].occupied) && (rects[i+1].occupied == rects[i+2].occupied))
                {
                    winner = rects[i].occupied;
                }

                if ((rects[j].occupied != "_") && (rects[j].occupied == rects[j+3].occupied) && (rects[j+6].occupied == rects[j+3].occupied))
                {
                    winner = rects[j].occupied;
                }

            }

            if(rects[4].occupied != "_"){
                if ((rects[0].occupied == rects[4].occupied) && (rects[8].occupied == rects[4].occupied))
                {
                    winner = rects[0].occupied;
                }

                if ((rects[2].occupied == rects[4].occupied) && (rects[6].occupied == rects[4].occupied))
                {
                    winner = rects[2].occupied;
                }
            }

            if(winner != "_"){
                trace("WINNER" + winner);
                for (i = 0; i < 9; i++) 
                {
                    if (rects[i].hasEventListener(MouseEvent.CLICK))
                    {
                        rects[i].removeEventListener(MouseEvent.CLICK,moveNextTurn)
                    }
                }

                var tf:TextField = addChild(new TextField()) as TextField;
                tf.defaultTextFormat = new TextFormat("", 20, 0xff0000);
                tf.text = winner + " wins";
                tf.x = 200;
                tf.y = 200;
            }
            if (currentMove == 9 && winner == "_") {
                trace("DRAW REEPLAy");
                //TODO: replay logic
            }

        }
    }
}
import flash.display.Graphics;
import flash.display.Sprite;

class Rect extends Sprite {
    public var id:Number;
    public var occupied:String = "_";// should be 0/_/X 
    function Rect() {
        var g:Graphics = this.graphics;
        g.lineStyle(1, 0x00ff00);
        g.beginFill(0x000000);
        g.drawRect(0, 0, 50, 50);
    }
}


class Circle extends Sprite {
    function Circle() {
        var g:Graphics = this.graphics;
        g.lineStyle(5, 0xff0000);
        g.drawCircle(10, 10, 10);
    }
}


class Cross extends Sprite {
    function Cross() {
        var g:Graphics = this.graphics;
        g.lineStyle(5, 0x0000ff);
        g.moveTo(0, 0);
        g.lineTo(20, 20);
        g.moveTo(20, 0);
        g.lineTo(0, 20);
    }
}
   