/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xNPW
 */

// forked from George.Profenza's SWF2SVG
package {
    import com.bit101.components.*;
    import com.codeazur.as3swf.*;
    import com.codeazur.as3swf.exporters.SVGShapeExporter;
    import com.codeazur.as3swf.tags.*;
    import com.codeazur.as3swf.tags.*;

    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.utils.*;
    
    
    public class SWF2SVG extends Sprite {
        
        private var swfFile:FileReference;
        private var svgFile:FileReference;
        private var status:Label;
        private var load : PushButton;
        private var save : PushButton;
        private var svg:XML;
        private var filename : String;
        
        public function SWF2SVG() {
            init();
        }
        private function init():void{
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            drawGUI();
        }
        private function drawGUI() : void {
            var vbox:VBox = new VBox(this);
            var buttons:HBox = new HBox(vbox);
            load = new PushButton(buttons,0,0,"Load SWF",selectSWF);
            save = new PushButton(buttons,0,0,"Save SVG",selectSVG);save.enabled = false;
            status = new Label(buttons,0,0,'load a SWF file');
        }
        private function selectSWF(event:MouseEvent):void{
            swfFile = new FileReference();
            swfFile.addEventListener(Event.SELECT,swfSelected);
            swfFile.addEventListener(Event.COMPLETE,swfLoaded);
            swfFile.browse([new FileFilter("SWF File (*.swf)", "*.swf")]);
        }
        private function selectSVG(event:MouseEvent):void{
            svgFile = new FileReference();
            var bytes:ByteArray = new ByteArray();
            bytes.writeUTFBytes(svg);
            svgFile.save(bytes,filename.replace('.swf','.svg'));
        }
        private function swfSelected(event:Event):void{
            swfFile.load();
            filename = swfFile.name;
            save.enabled = false;
        }
        private function swfLoaded(event:Event):void{
            var bytes:ByteArray = swfFile.data;
            var swf:SWF = new SWF(bytes);
            var svgExporter:SVGShapeExporter = new SVGShapeExporter(swf);
            for (var i:uint = 0; i < swf.tags.length; i++) {
                var tag:ITag = swf.tags[i];
                if (tag is TagDefineShape) TagDefineShape(tag).export(svgExporter);
              }
            svg = svgExporter.svg;
            if(svg != null){
                status.text = "ready! save the SVG file";
                save.enabled = true;
            }else status.text = "no shapes to export found";
        }

    }
    
}