/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xNFT
 */

// forked from FLASHMAFIA's YouBlur
// forked from J.J's flash on 2013-6-15
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.media.Camera;
    import flash.media.Video;

    [SWF(width = "465", height = "465")]
    public class YouBlur extends Sprite
    {
        private const NUM_P : uint = 22222;
        /* */
        private var ppp : Particle;
        private var bmd : BitmapData;
        private var vbmd : BitmapData;
        private var vid : Video;
        private var ct : ColorTransform;
        private var blur : BlurFilter;
        private var mirror : Matrix;

        public function YouBlur()
        {
            stage.stageFocusRect = mouseEnabled = tabEnabled = tabChildren = false;
            stage.scaleMode = 'noScale';
            stage.align = 'TL';
            stage.quality = 'high';
            stage.frameRate = 64;
            opaqueBackground = 0x0;

            var bm : Bitmap = new Bitmap(bmd = new BitmapData(512, 512, false, 0x0));
            bm.x = bm.y = (465 - 512) >> 1;
            bm.opaqueBackground = 0x0;
            addChild(bm);

            vbmd = new BitmapData(512, 512, false);

            var cam : Camera = Camera.getCamera();
            vid = new Video(512, 512);
            vid.deblocking = 1;
            vid.attachCamera(cam);

            mirror = new Matrix(-1, 0, 0, 1, 512, 0);
            ct = new ColorTransform(2.0, 2.0, 2.0);
            blur = new BlurFilter(4.0, 4.0, 1);

            var p : Particle = ppp = new Particle();
            var n : uint = NUM_P;
            while (n-- != 0)
            {
                p.x = Math.random() * 512;
                p.y = Math.random() * 512;
                p.vx = Math.random();
                p.vy = Math.random();
                p = p.next = new Particle();
            }

            addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(event : Event) : void
        {
            vbmd.draw(vid, mirror);
            vbmd.colorTransform(vbmd.rect, ct);

            bmd.lock();
            bmd.applyFilter(bmd, bmd.rect, bmd.rect.topLeft, blur);

            var p : Particle = ppp;
            while (p != null)
            {
                var px : int = (p.x >> 0) & 511;
                var py : int = (p.y >> 0) & 511;

                bmd.setPixel(px, py, vbmd.getPixel(px, py));

                var c0 : uint = vbmd.getPixel(px, py) & 0xFF;
                var c1 : uint = vbmd.getPixel(px + 1, py) & 0xFF;
    
                p.vx += (c1 - c0) / 50;
                p.vx *= 0.998;
                p.x += p.vx;

                c1 = vbmd.getPixel(px, py + 1) & 0xFF;
    
                p.vy += (c1 - c0) / 50;
                p.vy *= 0.998;
                p.y += p.vy;

                p = p.next;
            }

            bmd.unlock();
        }
    }
}

class Particle {
    public var next : Particle;
    public var x : Number;
    public var y : Number;
    public var vx : Number;
    public var vy : Number;
    public function Particle() {}
}