/**
 * Copyright Nyarineko ( http://wonderfl.net/user/Nyarineko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xMd9
 */

// forked from checkmate's Checkmate vol4 Massmedian
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
    import flash.filters.BlurFilter;
	import flash.display.PixelSnapping;
    import flash.events.MouseEvent;
	import flash.events.Event;
	import flash.geom.Matrix;
    import flash.geom.ColorTransform;
    import flash.geom.Rectangle;
    import flash.geom.Point;
	import org.papervision3d.core.effects.utils.BitmapClearMode;
	import org.papervision3d.core.geom.Pixels;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.BitmapEffectLayer;

	[SWF(width="465", height="465", backgroundColor="0x000000", frameRate="40")]
	public class Main extends BasicView{
	    private const RECT:Rectangle = new Rectangle(0, 0, 465, 465);
        private const ZEROS:Point = new Point(0, 0);
		private var _pixels:Pixels;
		private var _canvas:BitmapData;
        private var _head:Particle;
        private var _blurFilter:BlurFilter;
        private var _colorTransForm:ColorTransform;
        private var _mode:Number;
		
		private var mtx:Matrix;

		public function Main()
		{
			super(0, 0, true, true);
			var layer:BitmapEffectLayer=new BitmapEffectLayer(viewport, 465, 465, true, 0, BitmapClearMode.CLEAR_PRE, true);
			layer.clearBeforeRender=true;
			viewport.containerSprite.addLayer(layer);

			camera.z=-750;
			camera.y=-100;
			
			_pixels=new Pixels(layer);
			scene.addChild(_pixels);
			
            var p:Particle = _head = new Particle();
            for (var i:uint = 0; i < 6800; ++i){
                p = p.next = new Particle();
            }
			
			_canvas=new BitmapData(465 / 4, 465 / 4, false, 0x000000);
			var bmp:Bitmap=new Bitmap(_canvas, PixelSnapping.NEVER, true);
			bmp.scaleX=bmp.scaleY=4;
			bmp.smoothing=true;
			bmp.blendMode=BlendMode.ADD;
			addChild(bmp);
            _blurFilter = new BlurFilter(1, 1, 1);
            _colorTransForm = new ColorTransform(0.95, 0.95, 0.95);
			mtx = new Matrix(0.25, 0, 0, 0.25);
			startRendering();
			addEventListener(Event.ENTER_FRAME, onFrame);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, _move);
            _iniset();
		}
		
        private function _iniset():void{
            var p:Particle = _head;
            var i:Number = 1;
            var z:Number = 180;
            do {
				p.angle = i + i * Math.random();
				p.radius = i / 11;
				if(p.radius > z && i < 4500){
				  p.radius = p.radius  - 100 * Math.ceil(i/3300);
                }
                if(i >= 4500){
				  p.radius = 60;
                }
				p.yy= -(i / 11);
				if(i >= 5800){
				    p.yy= -(5800 / 11);
				    p.radius = 320 * Math.random() + 80;
				}
				p.xx=(p.radius * Math.cos(p.angle * Math.PI / 180));
				p.zz=(p.radius * Math.sin(p.angle * Math.PI / 180));
				if(i >= 5800){
				p.setPixel3Dsnow();
				}else{
				p.setPixel3D();
                }
				_pixels.addPixel3D(p.pix3d);
				_pixels.y = 300;
                i ++;
            } while (p = p.next);
		}
        private function _move(e:MouseEvent = null):void{
			camera.z = -(mouseX) - 430;
			camera.y = mouseY - 230;
		}

		private function onFrame(e:Event):void
		{
            _canvas.lock();
			_canvas.fillRect(_canvas.rect, 0x000000);
			_canvas.draw(viewport, mtx);
            _canvas.applyFilter(_canvas, RECT, ZEROS, _blurFilter);
			_canvas.colorTransform(RECT, _colorTransForm);
            _canvas.draw(_canvas, null, null, BlendMode.ADD);
            _canvas.unlock();
			_pixels.rotationY+=0.5;
		}
	}
}

internal class Particle {
	import org.papervision3d.core.geom.renderables.Pixel3D;
	public var radius:Number;
	public var angle:Number;
	public var xx:Number = 0;
	public var yy:Number = 0;
	public var zz:Number = 0;
	public var pix3d:Pixel3D;
	public var next:Particle;
		public function setPixel3D():void
		{
			pix3d=new Pixel3D((0xee << 24 | 0xff * Math.random() << 16 | 0xff * Math.random() << 8 | 0x99 * Math.random() ), xx, yy, zz);
		}
		public function setPixel3Dsnow():void
		{
			pix3d=new Pixel3D((0xff * Math.random() << 24 | 0xff << 16 | 0xff << 8 | 0xff ), xx, yy, zz);
		}
}