/**
 * Copyright mex_ichikawa ( http://wonderfl.net/user/mex_ichikawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xMYL
 */

// forked from mex's 【AS100本ノック】14回目：バルーン
/**
 * ドラッグでY軸回転します。
 * それだけ。。。
 * --
 * AS100本ノック
 * 14回目のお題は「バルーン」
 * あなたなりの「バルーン」を表現してください。
 **/

package
{
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.geom.Vector3D;
    import flash.utils.Timer;

    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.Sine;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.tweens.ITween;

    [SWF(width=465, height=465, backgroundColor=0x000000, frameRate=60)]
    public class BalloonWorld extends Sprite
    {
        public static const WIDTH:uint = 465;
        public static const HEIGHT:uint = 465;
        private static const _DELAY:uint = 300;
        private static const _MTIME:uint = 5;
        private static const _COLORS:Vector.<uint> = Vector.<uint>([
            0xFF0000,
            0x00FF00,
            0x0000FF,
            0xFFFF00,
            0xFF00FF,
            0x00FFFF,
            0xFFFFFF
        ]);
        private var _world:World;
        private var _container:Sprite;
        private var _balloons:Vector.<Balloon>;
        private var _isDrag:Boolean = false;
        private var _posX:int = 0;
        private var _rotate:int = 0;
        private var _preRotate:int = 0;
        private var _timer:Timer;
        public function BalloonWorld()
        {
            init();
        }

        private function init():void
        {
            Wonderfl.capture_delay(10);
            
            _world = new World;
            _world.rotate = _rotate;
            addChild(_world);

            _container = new Sprite;
            addChild(_container);

            _balloons = new Vector.<Balloon>;
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);

            _timer = new Timer(_DELAY, 0);
            _timer.addEventListener(TimerEvent.TIMER, timerHandler);
            _timer.start();
        }

        private function timerHandler(event:TimerEvent):void
        {
            var num:int = int(Math.random() * _COLORS.length);
            var bl:Balloon = new Balloon(_COLORS[num]);
            bl.x = Math.random() * WIDTH;
            bl.y = HEIGHT + bl.height;
            bl.z = Math.random() * WIDTH - WIDTH/2;
            bl.rotate = _rotate;

            var self:BalloonWorld = this;
            var t:ITween = BetweenAS3.tween(
                bl,
                {
                    y: -(bl.height*2)
                },
                null,
                Math.random()*_MTIME + _MTIME,
                Sine.easeOut
            );
            t.addEventListener(TweenEvent.COMPLETE, function(event:TweenEvent):void
            {
                self.destroy(bl);
            });
            t.play();

            _balloons.push(bl);
            _container.addChild(bl);
            setZPosition();
        }

        private function mouseDownHandler(event:MouseEvent):void
        {
            _posX = event.stageX;
            _isDrag = true;
        }
        private function mouseUpHandler(event:MouseEvent):void
        {
            _preRotate = _rotate;
            _isDrag = false;
        }
        private function mouseMoveHandler(event:MouseEvent):void
        {
            if(_isDrag)
            {
                var item:Balloon;
                var rot:Number = (event.stageX - _posX) / 2;
                _rotate = (_preRotate + rot) % 360;
                _world.rotate = _rotate;
                for each(item in _balloons)
                {
                    item.transform.matrix3D.appendTranslation(-WIDTH/2, -HEIGHT/2, 0);
                    item.transform.matrix3D.appendRotation(item.rotate - _rotate, Vector3D.Y_AXIS);
                    item.transform.matrix3D.appendTranslation(WIDTH/2, HEIGHT/2, 0);
                    item.rotate = _rotate;
                    item.rotationX = 0;
                    item.rotationY = 0;
                    item.rotationZ = 0;
                }
                setZPosition();
            }
        }
        private function destroy(balloon:Balloon):void
        {
            var item:Balloon;
            var balloons:Vector.<Balloon> = new Vector.<Balloon>;
            for each(item in _balloons)
            {
                if(balloon !== item)
                {
                    balloons.push(item);
                }
            }
            _balloons = balloons;
            if(balloon.parent === _container)
            {
                _container.removeChild(balloon);
            }
        }
        private function setZPosition():void
        {
            var i:uint,imax:uint;
            _balloons.sort(function(a:Balloon, b:Balloon):Number
            {
                return b.z - a.z;
            });
            for(i=0,imax=_balloons.length; i<imax; i++)
            {
                _container.setChildIndex(_balloons[i], i);
            }
        }
    }
}

import flash.display.BitmapData;
import flash.display.BlendMode;
import flash.display.GradientType;
import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Sprite;
import flash.filters.BevelFilter;
import flash.filters.BlurFilter;
import flash.filters.DropShadowFilter;
import flash.filters.GlowFilter;
import flash.geom.Matrix;
import flash.geom.Rectangle;

class Balloon extends Sprite
{
    private static const WIDTH:uint = 100;
    private static const HEIGHT:uint = 110;
    private static const LINE_HEIGHT:uint = 120;
    private var _c:uint;
    private var _h:Shape;
    private var _b:Shape;
    private var _l:Shape;
    private var _rotate:Number;

    public function Balloon(color:uint=0xFF0000)
    {
        _c = color;
        init();
    }
    private function init():void
    {
        _h = new Shape;
        _b = new Shape;
        _l = new Shape;
        _l.blendMode = BlendMode.ADD;
        addChild(_h);
        addChild(_b);
        addChild(_l);
        rotate = 0;
    }

    public function set rotate(num:Number):void
    {
        _rotate = num;
        draw();
    }
    public function get rotate():Number
    {
        return _rotate;
    }

    private function draw():void
    {
        var hg:Graphics = _h.graphics;
        var bg:Graphics = _b.graphics;
        var lg:Graphics = _l.graphics;

        var rot:Number = (rotate-90)%360;
        if(rot<0) rot = 360+rot;

        var r:Number = rot * Math.PI/180;
        var s:Number = Math.sin(r);
        var c:Number = Math.cos(r);
        var lw:Number = WIDTH * 1.2;
        var lh:Number = HEIGHT * 1.2;
        var lx:Number = (lw*0.5)*Math.cos(r);
        var ly:Number = (lh*0.25)*Math.sin(r);
        var mtx:Matrix = new Matrix();

        hg.clear();
        bg.clear();
        lg.clear();

        /**
         * ひも
         */
        hg.lineStyle(1, 0xFFFFFF);
        hg.moveTo(0, 0);
        hg.lineTo(0, HEIGHT/2 + LINE_HEIGHT);
        hg.beginFill(0xFFFFFF);
        hg.drawCircle(0.5, HEIGHT/2 + LINE_HEIGHT, 1);
        hg.endFill();
        hg.lineStyle();

        /**
         * べた
         */
        bg.beginFill(_c);
        bg.drawEllipse(
            -WIDTH/2,
            -HEIGHT/2,
            WIDTH,
            HEIGHT
        );
        bg.endFill();

        /**
         * かげ
         */
        _b.filters = [
            new DropShadowFilter(
                s<0 ? s * 10 : 0,
                90 + c * 30,
                0x000000, 1, 8, 8, 0.6, 3, true),
            new GlowFilter(0xFFFFFF, 0.4, 8, 8, s<0 ? 1 : 0, 3)
        ];


        /**
         * ひかり
         */
        mtx.createGradientBox(
            lw,
            lh,
            0,
            -lw/2 + lx,
            -HEIGHT + ly
        );
        lg.beginGradientFill(
            GradientType.RADIAL,
            [0xFFFFFF, 0xFFFFFF, 0xFFFFFF],
            [0.8, 0.5, 0],
            [0, 20, 255],
            mtx);
        lg.drawEllipse(
            -WIDTH/2,
            -HEIGHT/2,
            WIDTH,
            HEIGHT
        );
        lg.endFill();
    }
}

class World extends Sprite
{
    private static const TAILE_WIDTH:uint = 200;
    private var _bmd:BitmapData;
    private var _rotate:Number;
    private var _b:Shape;
    private var _m:Shape;
    private var _s:Shape;
    public function World()
    {
        init();
    }

    public function init():void
    {
        _bmd = new BitmapData(TAILE_WIDTH, BalloonWorld.HEIGHT, true, 0x00FFFFFF);
        _b = new Shape;
        _s = new Shape;
        _m = new Shape;
        _s.blendMode = BlendMode.SCREEN;
        addChild(_b);
        addChild(_s);
        addChild(_m);


        var mtx:Matrix = new Matrix();
        var g:Graphics = _b.graphics;
        /**
         * そら
         */
        mtx.createGradientBox(
            BalloonWorld.WIDTH,
            BalloonWorld.HEIGHT,
            90 * Math.PI/180
        );
        g.beginGradientFill(
            GradientType.LINEAR,
            [0x00b7ee, 0x00b7ee, 0xFFFFFF],
            [1, 1, 1],
            [0, 30, 255],
            mtx);
        g.drawRect(0, 0, BalloonWorld.WIDTH, BalloonWorld.HEIGHT);
        g.endFill();

        /**
         * タイル
         */
        var xx:Number = 0;
        var xp:Number = 0;
        var xc:Number = TAILE_WIDTH * 0.05;
        var _type:Vector.<int> = new Vector.<int>;
        var _pos2D:Vector.<Number> = new Vector.<Number>;
        g = _m.graphics;
        mtx.createGradientBox(
            TAILE_WIDTH,
            BalloonWorld.HEIGHT,
            90 * Math.PI/180
        );
        g.beginGradientFill(
            GradientType.LINEAR,
            [0x009944, 0x22ac38],
            [1, 1],
            [200, 255],
            mtx);
        g.lineStyle(2, 0x097c25);
        while(xx < TAILE_WIDTH-xc*2)
        {
            _type.push(1);
            xx += Math.random()*(xc/2);
            xp = xx;
            _pos2D.push(xx);
            _pos2D.push(BalloonWorld.HEIGHT);

            _type.push(2);
            xx += Math.random()*xc;
            _pos2D.push(xx);
            _pos2D.push(Math.random()*(BalloonWorld.HEIGHT*0.2) + BalloonWorld.HEIGHT*0.75);

            _type.push(2);
            xx += Math.random()*xc;
            _pos2D.push(xx);
            _pos2D.push(BalloonWorld.HEIGHT);

            _type.push(2);
            _pos2D.push(xp);
            _pos2D.push(BalloonWorld.HEIGHT);
        }
        g.drawPath(_type, _pos2D);
        g.endFill();
        _bmd.draw(_m);
        g.clear();
    }

    public function set rotate(num:Number):void
    {
        _rotate = num;
        draw();
    }
    public function get rotate():Number
    {
        return _rotate;
    }

    private function draw():void
    {
        var sg:Graphics = _s.graphics;
        var mg:Graphics = _m.graphics;
        var mtx:Matrix = new Matrix;
        var sx:Number = Math.sin(_rotate * Math.PI/180) * BalloonWorld.WIDTH;
        var tx:Number = _rotate * Math.PI/180 * 1080 % _bmd.width;

        /**
         * ざ・さん
         */
        sg.clear();
        if((Math.abs(_rotate) + 90) % 360 <= 180)
        {
            mtx.createGradientBox(
                BalloonWorld.WIDTH,
                BalloonWorld.HEIGHT,
                0,
                sx,
                -BalloonWorld.HEIGHT*0.4
            );
            sg.beginGradientFill(
                GradientType.RADIAL,
                [0xFFFFFF, 0xFFFFFF, 0xfffF00],
                [1, 1, 0],
                [0, 50, 255],
                mtx);
            sg.drawRect(0, 0, BalloonWorld.WIDTH, BalloonWorld.HEIGHT);
            sg.endFill();
        }

        /**
         * KU☆SA
         */
        mg.clear();
        mg.beginBitmapFill(_bmd, new Matrix(1, 0, 0, 1, tx, 0));
        mg.drawRect(0, 0, BalloonWorld.WIDTH, BalloonWorld.HEIGHT);
        mg.endFill();
    }
}



