/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xLws
 */

// --------------------------------------------------
// const(定数)だとインスタンス毎に値を変える必要がないので、
// static(静的)にしておくとメモリ節約という効果があります
// ボタンを押したら、ページをリロードして比較してください。
// --------------------------------------------------
package
{
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.system.System;

    public class Main extends Sprite
    {
        private static const ITERATE_NUM:int = 2000000;

        public function Main()
        {
            _label = new Label(this, 10, 100, "");

            new PushButton(this, 10, 10, "var", hoge);
            new PushButton(this, 160, 10, "const", piyo);
            new PushButton(this, 310, 10, "static const", moja);
        }
        private var _arr:Array;
        private var _label:Label;

        private function hoge(e:Event):void
        {
            _arr = [];
            System.gc();

            for (var i:int = 0; i < ITERATE_NUM; i++)
                _arr[i] = new Hoge();

            _label.text = "MEMORY : " + Math.round(System.totalMemory / 1000000) + "MB";
        }

        private function moja(e:Event):void
        {
            _arr = [];
            System.gc();

            for (var i:int = 0; i < ITERATE_NUM; i++)
                _arr[i] = new Moja();

            _label.text = "MEMORY : " + Math.round(System.totalMemory / 1000000) + "MB";

        }

        private function piyo(e:Event):void
        {
            _arr = [];
            System.gc();

            for (var i:int = 0; i < ITERATE_NUM; i++)
                _arr[i] = new Piyo();

            _label.text = "MEMORY : " + Math.round(System.totalMemory / 1000000) + "MB";
        }
    }
}

class Hoge
{
    public var myvar1:String = "0123456789";
    public var myvar2:String = "abcdefghijklmnopqrstrvwxyz";
}

class Piyo
{
    public const myvar1:String = "0123456789";
    public const myvar2:String = "abcdefghijklmnopqrstrvwxyz";
}

class Moja
{
    public static const myvar1:String = "0123456789";
    public static const myvar2:String = "abcdefghijklmnopqrstrvwxyz";
}