/**
 * Copyright Jacky.Riawan ( http://wonderfl.net/user/Jacky.Riawan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xLn5
 */

package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    /**
     * ...
     * @author Jacky Riawan
     */
     [SWF(backgroundColor="0x000000")]
    public class splat extends Sprite
    {
        public var blobList:Vector.<blob> = new Vector.<blob>()
        private var bitmapData:BitmapData;
        private var holder:Sprite;
        public function splat() 
        {
            bitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true,0x000000000)
            var bitmap:Bitmap = new Bitmap(bitmapData)
            holder = new Sprite()
            addChild(holder)
            var blobber:blob=new blob(stage.stageWidth / 2,stage.stageHeight / 2,125,holder,this)
            blobList.push(blobber)
            holder.addChild(blobber)
            addChild(bitmap)
            addEventListener(Event.ENTER_FRAME,render)
        }
        
        private function render(e:Event):void 
        {
            bitmapData.fillRect(bitmapData.rect, 0x00000000)
            
            bitmapData.draw(holder)
            bitmapData.applyFilter(bitmapData, bitmapData.rect, new Point(0, 0), new BlurFilter(18, 18, 15))
            
            bitmapData.threshold(bitmapData, bitmapData.rect, new Point(), ">", 0x80FFFFFFF, 0xFFFFFFFFF, 0xFFFFFFFFF)
            bitmapData.applyFilter(bitmapData, bitmapData.rect, new Point(0, 0), new GlowFilter(0xFFFFFFFF,1,4,4,10,1))
            blobList.sort(compare)
        }
        private function compare(blob1:blob, blob2:blob):void {
            var constrain:Number = Math.max(700, Math.pow(blob1.width*2, 2))
            var distx:Number = blob1.x - blob2.x
            var disty:Number = blob1.y - blob2.y
            var dist:Number=Math.pow(distx,2)+Math.pow(disty,2)
            var angle:Number = -Math.atan2(distx, disty);
            if(dist<constrain){
                blob1.speedx += ((dist-constrain)*Math.sin(angle))/constrain;
                blob1.speedy -= ((dist-constrain)*Math.cos(angle))/constrain;
                blob2.speedx -= ((dist-constrain)*Math.sin(angle))/constrain;
                blob2.speedy += ((dist-constrain) * Math.cos(angle))/constrain;
            }
            blob1.update()
            blob2.update()
        }
        
    }
    
}
import flash.display.Sprite;
import flash.events.MouseEvent;
class blob extends Sprite {
    public var speedx:Number = 0
    public var speedy:Number = 0
    private var myParent:splat
    private var myHolder:Sprite
    public function blob(posx:Number, posy:Number, size:Number, hold:Sprite, parent:splat) {
        myHolder=hold
        myParent=parent
        graphics.lineStyle(1, 0xFFFFFF)
        graphics.beginFill(0xFFFFFF,1)
        graphics.drawCircle(0, 0, size)
        x = posx
        y = posy
        addEventListener(MouseEvent.ROLL_OVER,split)
    }
    
    private function split(e:MouseEvent):void 
    {
        
        if(width>1){
            var obj1:blob = new blob(myParent.mouseX+.5+Math.random(), myParent.mouseY+.5+Math.random(), width / 3,myHolder, myParent)
            var obj2:blob = new blob(myParent.mouseX-.5-Math.random(), myParent.mouseY-.5-Math.random(), width / 3,myHolder, myParent)
            myParent.blobList.push(obj1,obj2)
            myHolder.addChild(obj1)
            myHolder.addChild(obj2)
        }
        removeEventListener(MouseEvent.ROLL_OVER,split)
        myParent.blobList.splice(myParent.blobList.indexOf(this,0),1)
        myHolder.removeChild(this)
        
    }
    public function update():void {
        x += speedx
        y += speedy
        speedx *= .9
        speedy *= .9
        if (x < 0) {
            x = stage.stageWidth
        }else if (x > stage.stageWidth) {
            x=0
        }
        if (y < 0) {
            y = stage.stageHeight
        }else if (y > stage.stageHeight) {
            y=0
        }
    }
}