/**
 * Copyright mex_md ( http://wonderfl.net/user/mex_md )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xKk5
 */

// forked from mex's 【AS100本ノック】6回目：爽快
/* 
 * AS100本ノック
 * 6回目のお題は「爽快」
 * あなたなりの「爽快」を表現してください。
 */
 /* 
 * Player10.1を入れてから、「ヤホー」と大きな声で叫んでください。爽快だと思います。
 */
package 
{
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.ActivityEvent;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.media.Sound;
	import flash.events.SampleDataEvent;
	import flash.media.Microphone;
	import flash.net.URLRequest;
	import flash.utils.ByteArray;
	import flash.utils.Timer;
	
	//import org.flashdevelop.utils.FlashConnect; 
	[SWF(width=465, height=465,frameRate=30)]
    public class Main extends Sprite
	{
		private const DELAY_LENGTH:int = 10000;
		private var mic:Microphone;
		
		private var writingPos:uint = 0;
		private var readingPos:uint =  0;
		private var mexDelayReadPos:uint = 0;
		private var delayTimer:Timer;
		private var snd:Sound;
		private var timer:Timer;
		private var ringBuffer:ByteArray;
		private var ringBufferFull:Boolean = false;
		private var streamBuffer:ByteArray = new ByteArray();
		private var loader:Loader;
		private const imgURL:String = "http://assets.wonderfl.net/images/related_images/8/8f/8f59/8f595dd6e2110f4d993b33ab4d17ee1a63f7912a"
		
		
		public function Main():void
		{
			loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImgLoaded);
			loader.load(new URLRequest(imgURL));
			
			initRingBuffer(44100 *int(DELAY_LENGTH*0.001));//リングバッファ初期化(44100kHz*最大ディレイ秒数*4バイト)
			
			mic = Microphone.getMicrophone();
			mic.rate = 44;
			mic.addEventListener(ActivityEvent.ACTIVITY, onActivity)
			//mic.setSilenceLevel(0,-1);
			mic.addEventListener(SampleDataEvent.SAMPLE_DATA, micSampleDataHandler);
        }
		
		/*-----------------------------------------//
		//onImgLoaded
		//------------------------------------------*/
		private function onImgLoaded(evt:Event):void 
		{
			loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onImgLoaded);
			this.addChild(loader);
		}
		
		/*-----------------------------------------//
		//onActivity
		//------------------------------------------*/
		private function onActivity(evt:ActivityEvent):void 
		{
			timer = new Timer(DELAY_LENGTH/10);
			timer.addEventListener(TimerEvent.TIMER, onTimerHandler)
			timer.start();
		}
		
		/*-----------------------------------------//
		//onTimerHandler
		//------------------------------------------*/
		private function onTimerHandler(evt:TimerEvent):void 
		{
			timer.stop();
			timer.removeEventListener(TimerEvent.TIMER, onTimerHandler)
			snd = new Sound();
			snd.addEventListener(SampleDataEvent.SAMPLE_DATA, onPlaybackSample);
			snd.play();
		}
		/*-----------------------------------------//
		//initRingBuffer
		//------------------------------------------*/
		private function initRingBuffer(ringLength:int):void
		{
			ringBufferFull = false;
			ringBuffer　= new ByteArray();
			for (var i:int = 0; i < ringLength; i++ )
			{
				ringBuffer.writeFloat(0);
				ringBuffer.writeFloat(0);
			}
			ringBuffer.position = 0;
		}
	
		/*-----------------------------------------//
		//onPlaybackSample
		//------------------------------------------*/
		private function onPlaybackSample(evt:SampleDataEvent):void 
		{
			var outLeft:Number;
			var outRight:Number;
			var readPosition:uint;
			var A0:Number = 1.0;
			var A1:Number = 0.5;
			var A2:Number = 0.25;
			var A3:Number = 0.13;
			var A4:Number = 0.06;
			var A5:Number = 0.03;
			
			var sample0L:Number
			var sample0R:Number
			var sample1L:Number;
			var sample1R:Number;
			var sample2L:Number;
			var sample2R:Number;
			var sample3L:Number;
			var sample3R:Number;
			var sample4L:Number;
			var sample4R:Number;
			var sample5L:Number;
			var sample5R:Number;
			
			streamBuffer.position = readingPos;
			for (var i:int = 0; i < 8192; i++) 
			{
				sample0L = streamBuffer.readFloat();
				sample0R = streamBuffer.readFloat();
				
				mexDelayReadPos = ringBuffer.position;
				ringBuffer.position = ((mexDelayReadPos - 44100 * 8) % ringBuffer.length);
				sample1L = A1 * ringBuffer.readFloat();
				sample1R = A1 * ringBuffer.readFloat();
				ringBuffer.position = ((mexDelayReadPos - 44100 * 16) % ringBuffer.length);
				sample2L = A2 * ringBuffer.readFloat();
				sample2R = A2 * ringBuffer.readFloat();
				ringBuffer.position = ((mexDelayReadPos - 44100 * 24) % ringBuffer.length);
				sample3L = A3 * ringBuffer.readFloat();
				sample3R = A3 * ringBuffer.readFloat();
				ringBuffer.position = ((mexDelayReadPos - 44100 * 32) % ringBuffer.length);
				sample4L = A4 * ringBuffer.readFloat();
				sample4R = A4 * ringBuffer.readFloat();
				ringBuffer.position = ((mexDelayReadPos - 44100 * 40) % ringBuffer.length);
				sample5L = A5 * ringBuffer.readFloat();
				sample5R = A5 * ringBuffer.readFloat();
					
				outLeft = sample0L + sample1L + sample2L + sample3L+sample4L+sample5L;
				outRight = sample0R + sample1R + sample2R + sample3R+sample4R+sample5R;
				ringBuffer.position = mexDelayReadPos;
				
				ringBuffer.writeFloat(sample0L);
				ringBuffer.writeFloat(sample0R);
				if(ringBuffer.position >= ringBuffer.length)
				{
				  ringBufferFull = true;
				  ringBuffer.position = 0;
				}
				evt.data.writeFloat(outLeft);
				evt.data.writeFloat(outRight);
			}
			readingPos = streamBuffer.position;
		}
		
		/*-----------------------------------------//
		//micSampleDataHandler
		//------------------------------------------*/
		private function micSampleDataHandler(evt:SampleDataEvent):void 
		{
			
			streamBuffer.position = writingPos;
	
			while(evt.data.bytesAvailable)
			{
				var sample:Number = evt.data.readFloat();
				streamBuffer.writeFloat(sample);
				streamBuffer.writeFloat(sample);
			}
			writingPos = streamBuffer.position;
		}
		
		
    }
}
