/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xJfp
 */

package
{
	import com.bit101.components.Label;
	import com.bit101.components.Slider;
	import flash.display.Sprite;
	import flash.events.Event;

	[SWF(framerate="30",width="480",height="480",backgroundColor="0xffffff")]
	public class Practice21 extends Sprite{
		private var list:Vector.<HSVCircle>;
		private var label:Label;
		private var slider:Slider;
		
		public function Practice21() {
			var r:RGBCircle = new RGBCircle(200,180);
			r.x = 240;
			r.y = 240;
			this.addChild(r);
			list = new Vector.<HSVCircle>();
			for (var i:int = 0; i < 10; i++) {
				var h:HSVCircle = new HSVCircle(170 - i * 15, 170 - i * 15 - 15, (10 - i) / 10, 1);
				h.x = 240;
				h.y = 240;
				this.addChild(h);
				list.push(h);
			}
			label = new Label(); 
			label.width = 20;
			label.text = "1.0";
			label.x = 350;
			label.y = 455;
			this.addChild(label);
			slider = new Slider(Slider.HORIZONTAL, this, 0, 0, onChange);
			slider.width = 200;
			slider.maximum = 10;
			slider.minimum = 0;
			slider.value = 10;
			slider.x = 140;
			slider.y = 460;
			this.addChild(slider);
		}
		
		private function onChange(e:Event):void {
			var val:Number = Math.round(slider.value) / 10.0;
			if (val == list[0].value) return;
			label.text = val.toString();
			for each(var h:HSVCircle in list) {
				h.value = val;
				h.init();
			}
		}
	}

}
import Box2D.Dynamics.Contacts.b2ContactResult;
import flash.display.MovieClip;
class ColorCircle extends MovieClip {
	private var radiusOuter:Number;
	private var radiusInner:Number;
	
	public function ColorCircle(r0:Number, r1:Number):void {
		radiusOuter = Math.max(r0, r1);
		radiusInner = Math.min(r0, r1);
	}
	
	public function init():void {
		for (var i:int = 0; i < 360; i++) {
			var x0:Number = Math.cos(i / 180 * Math.PI);
			var y0:Number = Math.sin(i / 180 * Math.PI);
			var x1:Number = Math.cos((i + 1) / 180 * Math.PI);
			var y1:Number = Math.sin((i + 1) / 180 * Math.PI);
			graphics.beginFill(getColor(i));
			graphics.moveTo(x0 * radiusInner, y0 * radiusInner);
			graphics.lineTo(x0 * radiusOuter, y0 * radiusOuter);
			graphics.lineTo(x1 * radiusOuter, y1 * radiusOuter);
			graphics.lineTo(x1 * radiusInner, y1 * radiusInner);
			graphics.lineTo(x0 * radiusInner, y0 * radiusInner);
			graphics.endFill();
		}
	}
	
	public function getColor(i:int):uint {
		return 0;
	}
}


class RGBCircle extends ColorCircle{
	private var red:Spline= new Spline(
			new Array(  0, 60,120,240,300,360),
			new Array(255,255,  0,  0,255,255));
	private var green:Spline= new Spline(
			new Array(  0, 60,180,240,360),
			new Array(  0,255,255,  0,  0));
	private var blue:Spline= new Spline(
			new Array(  0,120,180,300,360),
			new Array(  0,  0,255,255,  0));
	
	public function RGBCircle(r0:Number,r1:Number):void {
		super(r0, r1);
		init();
	}
	
	override public function getColor(i:int):uint {
		var rr:int = Math.max(0, Math.min(255, red.interpolate(i)));
		var gg:int = Math.max(0, Math.min(255, green.interpolate(i)));
		var bb:int = Math.max(0, Math.min(255, blue.interpolate(i)));			
		var color:uint = (rr << 16) + (gg << 8) + bb;
		return color;
	}
}

class HSVCircle extends ColorCircle {
	public var saturation:Number=1.0;
	public var value:Number=1.0;
	
	public function HSVCircle(r0:Number,r1:Number,s:Number,v:Number):void {
		super(r0, r1);
		this.saturation = s;
		this.value = v;
		init();
	}
	
	override public function getColor(i:int):uint {
		var h:Number = i / 60;
		var ii:Number = Math.floor(h);
		var ff:Number = h - ii;
		var p1:Number = value * (1.0 - saturation);
		var p2:Number = value * (1.0 - saturation * ff);
		var p3:Number = value * (1.0 - saturation * (1.0 - ff));
		var rv:Number;
		var gv:Number;
		var bv:Number;
		switch(ii) {
			case 0:
				rv = value;	gv = p3;	bv = p1;
				break;
			case 1:
				rv = p2;	gv = value;	bv = p1;
				break;
			case 2:
				rv = p1;	gv = value;	bv = p3;
				break;
			case 3:
				rv = p1;	gv = p2;	bv = value;
				break;
			case 4:
				rv = p3;	gv = p1;	bv = value;
				break;
			default:
				rv = value;	gv = p1;	bv = p2;
		}
		var rr:int = Math.max(0, Math.min(255, rv * 255));
		var gg:int = Math.max(0, Math.min(255, gv * 255));
		var bb:int = Math.max(0, Math.min(255, bv * 255));
		var color:uint = (rr << 16) + (gg << 8) + bb;
		return color;
	}
}

class Spline {
	private var num:int;
	private var x:Array;
	private var y:Array;
	private var z:Array;
	public function Spline(x:Array,y:Array):void{
		this.x = x;
		this.y = y;
		num = this.x.length;
		init();
	}
	
	private function init():void{
		z = new Array();
		var h:Array = new Array();
		var d:Array=new Array();
		z[0]=z[num-1]=0;
		for(var i:int=0;i<num-1;i++){
			h[i]=x[i+1]-x[i];
			d[i+1]=(y[i+1]-y[i])/ h[i];
		}
		z[1]=d[2]-d[1]-h[0]*z[0];
		d[1]=2*(x[2]-x[0]);
		for(i=1;i<num-2;i++){
			var t:Number=h[i]/d[i];
			z[i+1]=d[i+2]-d[i+1]-z[i]*t;
			d[i+1]=2*(x[i+2]-x[i])-h[i]*t;
		}
		z[num-2] -=h[num-2]*z[num-1];
		for(i=num-2;i>0;i--){
			z[i]=(z[i]-h[i]*z[i+1])/d[i];
		}
	}
	
	public function interpolate(t:Number):Number{
		var i:int=0;
		var j:int=num-1;
		while(i<j){
			var k:int=(i+j)/2;
			if(x[k]<t){
				i=k+1;
			}else{
				j = k;
			}
		}
		if(i>0)i--;
		var h:Number=x[i+1]-x[i];
		var d:Number= t - x[i];
		return (((z[i+1]-z[i])*d/h+z[i]*3)*d
					+((y[i+1]-y[i])/ h
					-(z[i]*2+z[i+1])*h))*d+y[i];
	}
}