/**
 * Copyright Glidias ( http://wonderfl.net/user/Glidias )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xIj5
 */

// forked from makc3d's [problem] Fix my marching squares?
package {
	import com.bit101.components.PushButton;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.net.FileFilter;
	import flash.net.FileReference;

	/**
	 * This marching squares alg uses 2x2 window
	 * and has deadlock problem, as described at
	 * http://www.sakri.net/blog/2009/05/28/detecting-edge-pixels-with-marching-squares-algorithm/
	 *
	 * Please come up with simplest possible fix :)
	 */
	public class MarchingSquares extends Sprite {
		public var file:FileReference, loader:Loader;
		public var image:BitmapData, image2:BitmapData;
		public function MarchingSquares () {
			file = new FileReference;
			file.addEventListener (Event.SELECT, onFileSelected);
			file.addEventListener (Event.COMPLETE, onFileLoaded);
			new PushButton (this, 0, 0, "LOAD IMAGE", onButtonClicked);
		}
        public function onButtonClicked (e:Event):void {
			file.browse ([new FileFilter ("Black'n'white image, please", "*.gif;*.png")]);
		}
        public function onFileSelected (e:Event):void { file.load (); }
        public function onFileLoaded (e:Event):void {
			loader = new Loader;
			loader.contentLoaderInfo.addEventListener (Event.COMPLETE, onImageReady);
			loader.loadBytes (file.data);
		}
		public function onImageReady(e:Event):void {
			if (loader.content) {
				loader.contentLoaderInfo.removeEventListener (Event.COMPLETE, onImageReady);

				image = loader.content ["bitmapData"];
				removeChildAt (0); addChild (new Bitmap (image));

				// threshold it just in case
				image.threshold (image, image.rect, image.rect.topLeft, ">=", 127, 0xFFFFFFFF, 0xFF);
				image.threshold (image, image.rect, image.rect.topLeft, "<",  127, 0xFF000000, 0xFF);

				image2 = new BitmapData (image.width, image.height, true, 0);
				addChild (new Bitmap (image2));

				w = image.width;
				at = new Point (0, image.height >> 1);
				imageData = image.getVector (image.rect);
				addEventListener (Event.ENTER_FRAME, marchingSquares);
			}
		}
		public var at:Point, w:int, imageData:Vector.<uint>;
		public function marchingSquares (e:Event):void {
			var nw:uint = imageData [w * at.y + at.x] & 1;
			var ne:uint = imageData [w * at.y + at.x + 1] & 1;
			if ((ne == 1) && (nw == 0)) {
				// we go up
				at.y--;
			} else {
				var sw:uint = imageData [w * (at.y + 1) + at.x] & 1;
				if ((nw == 1) && (sw == 0)) {
					// we go left
					at.x--;
				} else {
					var se:uint = imageData [w * (at.y + 1) + at.x + 1] & 1;
					if ((sw == 1) && (se == 0)) {
						// we go down
						at.y++;
					} else {
						// we go right
						at.x++;
					}
				}
			}
			image2.setPixel32 (at.x, at.y, 0xFFFF0000);
		}
	}
}