/**
 * Copyright tenasaku ( http://wonderfl.net/user/tenasaku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xHvt
 */

package {
	// 2010年4月2日
	// 玉というか太陽をドラッグして離すと自由落下
	// 計算はかなり杜撰
	// ----------------------
	// TODO: 誤差評価, 初速設定, 壁での反射
	// ----------------------
	// 同日夜8時
	// サイズ変更の処理が間違っていたので修正 
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    public class FlashTest extends Sprite {
		public static var ground:Number;
    		private const tDelta:Number = 1/16;
    		private const G:Number = -9.8;
   		private var b:MassiveBall = new MassiveBall();
   		private var bX:Number, bY:Number, vX:Number, vY:Number;
   		private function onMouseDown(e:MouseEvent):void {
   			b.startDrag();
   			stage.removeEventListener(Event.ENTER_FRAME, atEveryFrame);
   			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
   			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
   		}
   		private function onMouseMove(e:MouseEvent):void {
   			e.updateAfterEvent();
   		}
   		private function onMouseUp(e:MouseEvent):void {
   			b.stopDrag();
   			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
   			stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
   			vY = 0;
   			vX = 0;
   			bX = e.stageX - this.x - stage.stageWidth/2;
   			bY = ground - MassiveBall.RADIUS - e.stageY;
   			stage.addEventListener(Event.ENTER_FRAME, atEveryFrame);
   		}
   		private function onResize(e:Event):void {
   			ground = stage.stageHeight*7/8;
   			drawHorizon();
   			vX = 0;	vY = 0;
   			bX = 0;	bY = 0;
   			b.locate(bX,bY);
   		}
   		private function atEveryFrame(e:Event):void {
   			if ( (bY <= 0) && (vY<0) ) { // 非弾性衝突によるエネルギーのロス
   				vY = 0.9*Math.abs(vY);
   			} else { // 自由落下
	   			vY += G/MassiveBall.MASS*tDelta;
   			}
   			bX += vX*tDelta;
   			bY += vY*tDelta;
   			b.locate(bX,bY);
   		}
   		private function drawHorizon():void {
   			this.graphics.beginFill(0x330000);
   			this.graphics.drawRect(0,ground,stage.stageWidth,stage.stageHeight);
   			this.graphics.endFill();
   			var gm:Matrix = new Matrix();
   			gm.createGradientBox(ground,ground,Math.PI/2,0,0);
   			this.graphics.beginGradientFill(
   				GradientType.LINEAR,
   				[0x000066,0x9933ff,0xff9900],
   				[1,1,1],
   				[0,192,255],
   				gm,
   				SpreadMethod.PAD   				
   			);
   			this.graphics.drawRect(0,0,stage.stageWidth,ground);
   			this.graphics.endFill();
  		}
   		private function initialize(e:Event):void {
   			stage.align = StageAlign.TOP_LEFT;
   			stage.scaleMode = StageScaleMode.NO_SCALE;
   			stage.frameRate = 40;
   			ground = stage.stageHeight*7/8;
			drawHorizon();
    			this.addChild(b);
   			bX = 0;
   			bY = 0;
   			vX = 0;
   			vY = 0;
   			b.locate(bX,bY);
   			b.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
   			stage.addEventListener(Event.RESIZE, onResize);
   		}
        public function FlashTest() {
            if ( stage != null ) {
            		initialize(null);
            } else {
            		this.addEventListener(Event.ADDED_TO_STAGE, initialize);
            }
            
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;

class MassiveBall extends Sprite {
	public static const RADIUS:Number = 30;
	public static const MASS:Number = 1.0;
	public function locate(X:Number,Y:Number):void {
		this.x = stage.stageWidth/2 + X;
		this.y = FlashTest.ground - Y - RADIUS;
	}
	public function MassiveBall() {
		this.graphics.clear();
	  	var gm:Matrix = new Matrix();
   		gm.createGradientBox(RADIUS*2,RADIUS*2,Math.PI/2,0,-RADIUS);
   		this.graphics.beginGradientFill(
   			GradientType.LINEAR,
   			[0xff6600,0xcc0000],
   			[1,1],
   			[0,255],
   			gm,
   			SpreadMethod.PAD   				
   		);
		this.graphics.drawCircle(0,0,RADIUS);
   		this.graphics.endFill();
	}
}