/**
 * Copyright _shimabox ( http://wonderfl.net/user/_shimabox )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xGf6
 */

package 
{
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.display.Stage;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.filters.GlowFilter;
	import flash.geom.Point;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	import net.hires.debug.Stats;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.tweens.ITween;
	import org.libspark.betweenas3.events.TweenEvent;
	
	/**
	 * ...
	 * マウスダウンでパワーを貯めて、任意の場所でマウスアップ　→　発射
	 * @author _shimabox
	 */
	public class Main extends Sprite 
	{
		private const TIMER_COUNT:int = 100;
		private const COLOR:uint = 0xffff00;
		private const GLOW_COLOR:uint = 0xff8989;
		private const LINIT_SIZE:uint = 20;
		private var _dodonpa:Sprite;
		private var _downPoint:Point;
		private var _upPoint:Point;
		private var _drawTimer:Timer;
		private var _downTimer:Timer;
		private var _addX:Number = 0;
		private var _addY:Number = 0;
		private var _lineGF:GlowFilter;
		private var _dodonGF:GlowFilter;
		private var _bf:BlurFilter;
		private var _downTime:int = 0;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			this.stage.addEventListener(MouseEvent.MOUSE_DOWN, this.mouseDownHandler);
			this._lineGF = new GlowFilter(COLOR , 1, 6, 6, 2, 1, false, true);
			this._dodonGF = new GlowFilter(GLOW_COLOR, 1, 16, 16);
			this._bf = new BlurFilter(16, 16, 1);
                        Wonderfl.capture_delay( 5 );
			//this.addChild(new Stats());
		}
		
		private function mouseDownHandler(e:MouseEvent):void
		{	
			if (this._drawTimer) return;
			this._downTime = 0;
			this.initMousePoint();
			this._downPoint = new Point(this.mouseX, this.mouseY);
			this.stage.addEventListener(MouseEvent.MOUSE_UP, this.mouseUpHandler);
			this._downTimer = new Timer(100,0)
			this._downTimer.start();
			this._downTimer.addEventListener(TimerEvent.TIMER, this.drawPower);
		}
		
		private function initMousePoint():void
		{
			this._downPoint = this._upPoint = null;
		}
		
		private function drawPower(e:TimerEvent):void
		{
			this.collectPower();
			this.savePower();
		}
		
		private function collectPower():void
		{
			var power:Sprite = new Sprite();
			var g:Graphics = power.graphics;
			var pr:int = this._downTime + 150 + ((Math.random() * 100)-50)>>0;
			var theta:Number = (Math.random() * 360) >> 0;
			var r:int = (Math.random() * 10) >> 0;
			var red:uint = ( COLOR & 0xff0000 ) >> 16;
			var green:uint = ( COLOR & 0xff00 ) >> 8;
			var blue:uint = ( COLOR & 0xff );
			var rs:String, gs:String, bs:String;
			rs = '0' +  (red).toString(16);
			gs = '0' +  (green - Math.random()*200 >> 0).toString(16);
			bs = '0' +  (blue).toString(16);
			var color:uint = uint('0x' + rs + gs + bs);
			g.clear();
			g.beginFill(color, 1);
			g.drawCircle(0, 0, r < 1 ? 1 : r);
			g.endFill();
			power.filters = [this._bf];
			power.x = pr * Math.cos(theta) + _downPoint.x;
			power.y = pr * Math.sin(theta) + _downPoint.y;
			
			this.addChild(power);
			
			BetweenAS3.apply(power,
				{ 
					_glowFilter: {
						blurX: 16,
						blurY: 16,
						alpha: 1,
						color:GLOW_COLOR
					}
				} 
			);
			
			var _tween:ITween = BetweenAS3.tween(power,
				{
					x: this._downPoint.x, y: this._downPoint.y, alpha: .2,
					_glowFilter: {
						blurX: 16,
						blurY: 16,
						alpha: .2
					}
				},
				{z: Math.floor(Math.random() * 2) % 2 ? 500 : -100},
				1
			);
			
			_tween.addEventListener(TweenEvent.COMPLETE, tweenComplete);
			_tween.play();
		}
		
		private function tweenComplete(e:TweenEvent):void 
		{
			if (this.contains(e.target.target)) 
				this.removeChild(e.target.target);
		}
		
		private function savePower():void
		{
			if (this._downTime <= LINIT_SIZE) this._downTime++;
			else return;
			
			var power:Sprite = new Sprite();
			var g:Graphics = power.graphics;
			
			g.clear();
			g.beginFill(COLOR, 0.8);
			g.drawCircle(0, 0, this._downTime);
			g.endFill();
			if (this._downTime >= 4) power.filters = [this._bf, this._dodonGF];
			power.x = this._downPoint.x;
			power.y = this._downPoint.y;
			this.addChild(power);
		}
		
		private function mouseUpHandler(e:MouseEvent):void
		{	
			this.stage.removeEventListener(MouseEvent.MOUSE_UP, this.mouseUpHandler);
			this._upPoint = new Point(this.mouseX, this.mouseY);
			this._downTimer.stop();
			this._downTimer.removeEventListener(TimerEvent.TIMER, this.drawPower);
			this.clear();
			this.draw();
		}
		
		private function draw():void
		{
			var diffX:Number = _upPoint.x - _downPoint.x;
			var diffY:Number = _upPoint.y - _downPoint.y;
			var diff:Number = Math.sqrt(diffX * diffX + diffY * diffY);
			var sw:Number = this.stage.stageWidth;
			this._drawTimer = new Timer(sw / 4 > diff ? 1 : sw / 2 > diff ? 4 : 8, TIMER_COUNT)
			this._drawTimer.start();
			this._drawTimer.addEventListener(TimerEvent.TIMER, onTimerHandler);
			this._drawTimer.addEventListener(TimerEvent.TIMER_COMPLETE, onCompleteTimerHandler);
			this._dodonpa = new Sprite();
			var g:Graphics = this._dodonpa.graphics;
			g.clear();
			g.beginFill(COLOR, 0.8);
			g.drawCircle(0, 0, this._downTime);
			g.endFill();
		}
		
		private function onTimerHandler(e:TimerEvent):void 
		{
			var dp:Point = this._downPoint;
			var up:Point = this._upPoint;
			var cnt:int   = this._drawTimer.currentCount;
			var diffX:Number = (up.x - dp.x) / TIMER_COUNT;
			var diffY:Number = (up.y - dp.y) / TIMER_COUNT;
			var line:Sprite = new Sprite();
			var g:Graphics = line.graphics;
			g.clear();
			g.lineStyle(1, 0, 1);
			
			switch(cnt)
			{
				case 1 : 
					g.moveTo(dp.x, dp.y)
					g.lineTo(dp.x + diffX, dp.y + diffY)
					this._addX = dp.x + diffX;
					this._addY = dp.y + diffY;
					this._dodonpa.x = dp.x + diffX;
					this._dodonpa.y = dp.y + diffY;
					this._dodonpa.filters = [this._bf, this._dodonGF];
					this.addChild(this._dodonpa);
					break;
				case TIMER_COUNT : 
					g.moveTo(this._addX, this._addY);
					g.lineTo(up.x, up.y);
					this._dodonpa.x = up.x
					this._dodonpa.y = up.y
					break;
				default : 
					g.moveTo(this._addX, this._addY);
					this._addX += diffX;
					this._addY += diffY;
					g.lineTo(this._addX, this._addY);
					this._dodonpa.x = this._addX;
					this._dodonpa.y = this._addY;
				    break;
			}
			
			line.filters = [this._lineGF,this._dodonGF];
			this.addChildAt(line, cnt);
			this.swapChildren(this._dodonpa, line);
		}
		
		private function onCompleteTimerHandler(e:TimerEvent):void 
		{
			this._drawTimer.removeEventListener(TimerEvent.TIMER, onTimerHandler);
			this._drawTimer.removeEventListener(TimerEvent.TIMER_COMPLETE, onCompleteTimerHandler);
			this._drawTimer = null;
			this.clear();
		}
		
		private function clear():void
		{
			while (this.numChildren > 0) {
				this.removeChildAt(0);
				if(this._dodonpa) this._dodonpa = null;
			}
		}
	}
}