/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xF6P
 */

// forked from shaktool's Peak
// borrowed some code from psyark's BumpyPlanet:
// http://wonderfl.kayac.com/code/d79cd85845773958620f42cb3e6cb363c2020c73

package {
  import flash.display.*;
  import flash.events.*;
  import flash.filters.*;
  import flash.geom.*;
  import flash.text.*;
  import flash.utils.*;
  
  [SWF(width=465, height=465, frameRate=24, backgroundColor=0x000000)]
  public class Peak extends Sprite {
    private const WIDTH: int = 200;
    private const HEIGHT: int = 200;
    private const MAX: int = 255;
    private const MIN: int = 0;
    
    private var lifeMap: BitmapData = new BitmapData(WIDTH, HEIGHT, true , 0);
    private var heatMap: BitmapData = new BitmapData(WIDTH, HEIGHT, false, 0);
    private var flipMap: BitmapData = new BitmapData(WIDTH, HEIGHT, false, 0);
    
    private var onScreenHeatMap: Bitmap;
    
    public function Peak() {
      stage.align = StageAlign.BOTTOM;
      stage.scaleMode = StageScaleMode.NO_SCALE;
      generate(null)
      stage.addEventListener(MouseEvent.CLICK, generate);
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
      
      onScreenHeatMap = new Bitmap(heatMap);
      addChild(onScreenHeatMap);
      addChild(new Bitmap(lifeMap));
    }
    public function generate(event: MouseEvent): void {
      var i: int;
      
      lifeMap.fillRect(new Rectangle(0,0,WIDTH,HEIGHT), 0)
      for (i = 0; i < 20; i++) {
        lifeMap.setPixel32(Math.random() * WIDTH, Math.random() * HEIGHT, 0xffffffff);
      }
      //heatMap.fillRect(new Rectangle(0,0,WIDTH,HEIGHT), 0)
    }
    
    private function onEnterFrame(event: Event): void {
      var i: int;
      var j: int;
      
      var target: uint = 0xffffffff;
      
      flipMap.lock();
      
      for (j = 0; j < HEIGHT; j++) {
        var row1: int = (j == 0) ? HEIGHT - 1 : j - 1;
        var row2: int = j;
        var row3: int = (j == HEIGHT - 1) ? 0 : j + 1;
        
        var sample1: uint;
        var sample2: uint;
        var sample3: uint = heatMap.getPixel(WIDTH-1, row2);
        if (lifeMap.getPixel32(WIDTH-1, row2) == target) sample3 = MAX;
        var sample4: uint = heatMap.getPixel(0, row2);
        if (lifeMap.getPixel32(0, row2) == target) sample4 = MAX;
        var sample5: uint;
        
        for (i = 0; i < WIDTH; i++) {
          var nextCol: int = (i == WIDTH-1) ? 0 : i+1;
          sample2 = sample3;
          sample3 = sample4;
          sample4 = heatMap.getPixel(nextCol, row2);
          if (lifeMap.getPixel32(nextCol, row2) == target) sample4 = MAX;
          
          if (sample3 == MAX) {
            flipMap.setPixel(i,j, MAX-1);
            continue;
          }
          
          sample1 = heatMap.getPixel(i, row1);
          if (lifeMap.getPixel32(i, row1) == target) sample1 = MAX;
          sample5 = heatMap.getPixel(i, row3);
          if (lifeMap.getPixel32(i, row3) == target) sample5 = MAX;
          
          var max: uint = sample1;
          if (sample2 > max) max = sample2;
          if (sample4 > max) max = sample4;
          if (sample5 > max) max = sample5;
          
          flipMap.setPixel(i,j, (max <= 1) ? 0 : max-2);
        }
      }
      
      flipMap.unlock();
      
      var tempMap: BitmapData = heatMap;
      heatMap = flipMap;
      flipMap = tempMap;
      onScreenHeatMap.bitmapData = heatMap;
    }
  }
}
