/**
 * Copyright beryu ( http://wonderfl.net/user/beryu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xF5o
 */

/* wonderfl作品のキャプチャ用アプリ
 * サイズ指定出来るようにして、壁紙を作れるようにしても面白いかも。
 * 
 * ※これでキャプチャできない作品も結構あるみたいです。。。
 *  原因は何なんだろう。
 * ※初期値にはyd_niku様のMikanGridをお借りしました。多謝！
 *  http://wonderfl.net/code/b6a4645461857e6f46909aea3787fe8dd30e4830
 */
package
{
    import flash.text.*;
    import flash.display.*;
    import flash.net.*;
    import flash.events.*;
    import flash.utils.*;
    import flash.system.*;
    
    import com.adobe.images.PNGEncoder;
    
    import net.wonderfl.utils.WonderflSWFUrl;
    
    public class ImagePublisher extends Sprite
    {
        private var _baseSprite:Sprite;
        private var _loadBtn:Sprite;
        private var _clearBtn:Sprite;
        private var _saveBtn:Sprite;
        private var _ba:ByteArray;
        private var _inputField:TextField;
    	
        public function ImagePublisher()
        {
            stage.scaleMode=StageScaleMode.NO_SCALE;
            
            // 読み込んだswfを書き込むBitmapData準備
            _baseSprite = new Sprite();
            addChild(_baseSprite);
            
            // 入力フォーム作る
            var form:Sprite = new Sprite();
            var tf:TextField = new TextField();
            tf.text = 'http://wonderfl.net/code/';
            tf.selectable = false;
            tf.textColor = 0xFFFFFF;
            tf.width = 120;
            tf.height = 15;
            tf.y = 2;
            form.addChild(tf);
            _inputField = new TextField();
            _inputField.type = TextFieldType.INPUT;
            _inputField.border = true;
            _inputField.borderColor = 0x666666;
            _inputField.width = 200;
            _inputField.height = 15;
            _inputField.background = true;
            _inputField.backgroundColor = 0xFFFFFF;
            _inputField.x = 120;
            form.addChild(_inputField);
            
            // ボタン作る
            _loadBtn = new Sprite();
            _loadBtn.graphics.beginFill(0x992222);
            _loadBtn.graphics.drawRect(0, 0, 50, 16);
            _loadBtn.graphics.endFill();
            _clearBtn = new Sprite();
            _clearBtn.graphics.beginFill(0x222299);
            _clearBtn.graphics.drawRect(0, 0, 50, 16);
            _clearBtn.graphics.endFill();
            _saveBtn = new Sprite();
            _saveBtn.graphics.beginFill(0x666666);
            _saveBtn.graphics.drawRect(0, 0, 50, 16);
            _saveBtn.graphics.endFill();
	    form.addChild(_loadBtn);
	    form.addChild(_clearBtn);
	    form.addChild(_saveBtn);
            
    	    // ボタンにラベルを貼る
    	    tf = new TextField();
    	    tf.text = 'load';
    	    tf.textColor = 0xFFFFFF;
            tf.selectable = false;
            tf.x = 12;
            tf.y = 1;
    	    _loadBtn.addChild(tf);
            tf = new TextField();
            tf.text = 'clear';
            tf.textColor = 0xFFFFFF;
            tf.selectable = false;
            tf.x = 12;
            tf.y = 1;
            _clearBtn.addChild(tf);
            tf = new TextField();
            tf.text = 'save';
            tf.textColor = 0xFFFFFF;
            tf.selectable = false;
            tf.x = 12;
            tf.y = 1;
            _saveBtn.addChild(tf);
            
            // 説明
            var intro:TextField = new TextField();
            intro.text = 'wonderflのSWFをキャプチャして、画像として保存します。';
            intro.autoSize = TextFieldAutoSize.LEFT;
            intro.selectable = false;
            intro.textColor = 0xFFFFFF;
            var note:TextField = new TextField();
            note.text = '※スペースキーでも保存できます。';
            note.autoSize = TextFieldAutoSize.LEFT;
            note.selectable = false;
            note.textColor = 0xFFFFFF;
            form.addChild(note);
            
            // パネルにまとめる
            var panel:Sprite = new Sprite();
            panel.addChild(intro);
            panel.addChild(form);
            addChild(panel);
            
    	    // 位置を調節
            intro.x = 5;
            intro.y = 5;
            form.x = 5;
            form.y = intro.height + 5;
            
            panel.x = 0;
            panel.y = 0;
            _loadBtn.x = 321;
            _loadBtn.y = 0;
    	    _clearBtn.x = 371;
            _clearBtn.y = 0;
    	    _saveBtn.x = 0;
            _saveBtn.y = intro.y + intro.height;
            note.x = 60;
            note.y = intro.y + intro.height + 2;
            
            // パネル装飾
            panel.graphics.beginFill(0x000000);
            panel.graphics.drawRect(0, 0, 435, 65);
            panel.graphics.endFill();
            panel.alpha = 0.8;
            
            // event
            _loadBtn.addEventListener(MouseEvent.CLICK, loadBtnClickHandler);
            _clearBtn.addEventListener(MouseEvent.CLICK, clearBtnClickHandler);
            _saveBtn.addEventListener(MouseEvent.CLICK, saveBtnClickHandler);
            stage.addEventListener(KeyboardEvent.KEY_UP, stageKeyUpHandler);
            _inputField.addEventListener(KeyboardEvent.KEY_UP, inputFieldKeyUpHandler);
            
            // default値設定
            _inputField.text = 'b6a4645461857e6f46909aea3787fe8dd30e4830';
            loadBtnClickHandler();
	}
        
        /**
         * 入力されたURLからSWFをロード
         */
        private function loadBtnClickHandler(e:MouseEvent = null):void
        {
            var url:String = 'http://wonderfl.net/code/' + _inputField.text;
            var path:String = WonderflSWFUrl.getURLFromPageURL(url);
            if(path == null)
            { // 正しいURLではなかった
                _inputField.backgroundColor = 0xFF0000;
                return;
            }
            else
            {
                _inputField.backgroundColor = 0xFFFFFF;
            }
            var ldr:Loader = new Loader();
            var context:LoaderContext = new LoaderContext(true);
            context.applicationDomain = ApplicationDomain.currentDomain;
            
            ldr.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void
            {
                // 表示
                _baseSprite.addChild(ldr);
            });
            
            ldr.load(new URLRequest(path), context);
        }
        
        /**
         * 表示中のSWFを全消去
         */
        private function clearBtnClickHandler(e:MouseEvent):void
        {
            var length:int = _baseSprite.numChildren;
            for(var i:int = 0; i < length; i++)
            {
                _baseSprite.removeChildAt(0);
            }
        }
        
        /**
         * 表示中のSWFのPNG画像を出力
         */
        private function saveBtnClickHandler(e:MouseEvent = null):void
        {
            // 外部swfをPNG化
            var bmd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight);
            bmd.draw(_baseSprite);
            _ba = PNGEncoder.encode(bmd);
            
            // 保存ダイアログ表示
            var fr:FileReference = new FileReference();
            fr.save(_ba, 'wonderfl.png');
        }
        
        /**
         * saveボタンの代わりにキーボードからでも保存できるようにする
         */
        private function stageKeyUpHandler(e:KeyboardEvent):void
        {
            if(e.charCode == 32)
            {
                saveBtnClickHandler();
            }
        }
        
        /**
         * loadボタンの代わりにキーボードからでも読み込みできるようにする
         */
        private function inputFieldKeyUpHandler(e:KeyboardEvent):void
        {
            if(e.charCode == 13)
            {
                loadBtnClickHandler();
            }
        }

    }
}