/**
 * Copyright rettuce ( http://wonderfl.net/user/rettuce )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xDe0
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 60)]
    
    /**
     * ...
     * @author rettuce
     * 
     */
    public class Main extends Sprite
    {
        private var NUM:int = 20;
        private var _minDist:Number = 130;
        private var _springAmount:Number  = 0.001 // バネ係数
        private var _bounce:Number = -0.8;
        private var _ballArr:Array = [];
        private var _flg:Boolean = true;
        
        public function Main()
        {
            init();
        }
        
        public function init():void
        {
            for(var i:int=0; i<NUM; i++ ){
                var b:Ball = new Ball(10);
                b.x = stage.stageWidth*Math.random();
                b.y = stage.stageHeight*Math.random();
                b._vx = 3*Math.random() - 1;
                b._vy = 3*Math.random() - 1;
                b._mass = 3 * Math.random() + 2;
                addChild(b);
                _ballArr.push(b);
            }
            addEventListener(Event.ENTER_FRAME, enterframeHandler);
            stage.addEventListener(MouseEvent.CLICK, clickcheck);
            clickcheck(null);
        }
        private function clickcheck(e:MouseEvent):void
        {
            if (_flg == false ) {
                for(var i:int=0; i<NUM; i++ ){
                    var b:Ball = _ballArr[i];
                    b.visible = true;
                }
                _flg = true;
            } else {
                for(var n:int=0; n<NUM; n++ ){
                var B:Ball = _ballArr[n];
                B.visible = false;
                }
                _flg = false;
            }
        }
        
        private function enterframeHandler(e:Event):void
        {
            graphics.clear();
            
            for(var i:int=0; i<NUM; i++ ){
                var b:Ball = _ballArr[i];
                b.x += b._vx;
                b.y += b._vy;
                checkWalls(b);
            }
            
            for(i=0; i<NUM-1; i++ ){
                var b0:Ball = _ballArr[i];
                for(var n:int=i+1; n<NUM; n++){
                    var b1:Ball = _ballArr[n];
                    spring(b0, b1);
                }
            }            
        }
        private function spring(b0:Ball, b1:Ball):void
        {
            var dx:Number = b1.x - b0.x;
            var dy:Number = b1.y - b0.y;
            var dist:Number = Math.sqrt(dx * dx + dy * dy);
            if (dist < _minDist&&dist>10)
            {
                var cx:Number = dx/2+b0.x;
                var cy:Number = dy/2+b0.y;
                
                graphics.beginFill(0xFFFFFF*Math.random() );
                graphics.drawCircle(cx, cy, _minDist / dist * 2 );
                
                if (_flg == true) {
                    graphics.lineStyle(1, 0xFF0000, 0.5 );
                    graphics.moveTo(b0.x, b0.y);
                    graphics.lineTo(b1.x, b1.y);
                }                
                
                var ax:Number = dx * _springAmount;
                var ay:Number = dy * _springAmount;
                b0._vx += ax / b0._mass;
                b0._vy += ay / b0._mass;
                b1._vx -= ax / b1._mass;
                b1._vy -= ay / b1._mass;
            }
        }
        
        private function checkWalls(b:Ball):void
        {
            if(b.x+b.width/2 > stage.stageWidth){
                b.x = stage.stageWidth-b.width/2;                    
                b._vx *= _bounce;                    
            }else if( b.x-b.width/2 < 0 ){
                b.x = b.width/2;                    
                b._vx *= _bounce;                    
            }
            if( b.y+b.height/2 > stage.stageHeight ){
                b.y = stage.stageHeight-b.height/2;                    
                b._vy *= _bounce;    
            }else if( b.y-b.height/2 < 0){
                b.y = b.height/2;                    
                b._vy *= _bounce;    
            }
        }
    }
}

import flash.display.Sprite;
class Ball extends Sprite
{
    public var _radius:Number;
    private var _color:Number;
    public var _vx:Number = 0;
    public var _vy:Number = 0;
    public var _mass:Number = 1;
    
    public function Ball(radius:Number = 40, color:Number = 0xFF0000)
    {
        _radius = radius;
        _color = color;
        init();
    }
    
    public function init():void
    {
        graphics.beginFill(_color);
        graphics.drawCircle(0,0,_radius);
        graphics.endFill();
    }
}
