/**
 * Copyright terra1119 ( http://wonderfl.net/user/terra1119 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xDMj
 */

// forked from bradsedito's Shimmer
// forked from bradsedito's LiveWarp :[ff]
/*  mouseMove : move perspective point
    mouseDown : speed up
    mouseUp   : speed down                    */


package 
{
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.*;
    import flash.display.*;
    import flash.filters.BlurFilter;
    import flash.display.BlendMode;
    
    [SWF(  width=465,height=465,backgroundColor=0x000000  )]
    
    
    public class Warp extends Sprite 
    {
        private const  W           :int          =  stage.stageWidth
        private const  H           :int          =  stage.stageHeight
        private const  P           :Number       =  800
        private const  SY          :Number       =  2
        private const  R           :Number       =  P*SY/(2*Math.PI)
        private const  PI          :Number       =  Math.PI            
        private var    N           :uint         =  10        
        private var  seed          :int          =  new  Date().time
        private var _mode          :Boolean      =  true
        private var    _stepX      :Number        
        private var    _bmds       :Array
        private var    _ox         :Point
        private var    _bmd        :BitmapData
        private var    _canvas     :Sprite
        private var   _perspective :PerspectiveProjection
        private var    perspective :PerspectiveProjection

            public function Warp() 
            {
                // ENTRY POINT: /////////////////////////////////////////////////////////////////////////////////
                perspective = this.transform.perspectiveProjection
                perspective.fieldOfView = 4                
                
                _perspective = this.transform.perspectiveProjection
                _perspective.fieldOfView = 80
                
                addEventListener(Event.ENTER_FRAME, onEnterFrameHandler)
                stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDownHandler)
                stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUpHandler)
                
                graphics.beginFill(0)
                graphics.drawRect(0, 0, W, H)
                graphics.endFill()
                
                _canvas = new Sprite()
                _canvas.x = stage.stageWidth/2
                _canvas.y = stage.stageHeight/2
                addChild(_canvas)
                
                _bmd = new BitmapData(200, P, false, 0x000000)
                _bmds = []
                
                for(var i : uint = 0;i < N;i++)
                {
                        var bmd : BitmapData  = new BitmapData(200, P / N, false, 0xffffff)
                        var bmp : Bitmap      = new Bitmap(bmd)
                        bmp.x           =  R * Math.cos(i * 2 * Math.PI/N)
                        bmp.y           =  R * Math.sin(i * 2 * Math.PI/N)
                        bmp.z           =  4000
                        bmp.scaleX      =  40
                        bmp.scaleY      =  SY
                        bmp.rotationY   =  90
                        bmp.rotationX   =  -(i + 0.5) / N * 360
                        _bmds.push(bmd)                        
                        _canvas.addChild(bmp)
                }                
                
                _ox     =  new Point(int.MAX_VALUE, 0)
                _stepX  =  -5;
                
                var sp:Sprite = new Sprite();
                sp.graphics.beginFill(0x000000,1);
                sp.graphics.drawCircle(0,0,18);
                sp.graphics.endFill();
                
                var blur:BlurFilter = new BlurFilter(8,8);
                sp.filters = [blur];
                sp.blendMode = BlendMode.OVERLAY;
                addChild(sp);
                sp.x = W /2;
                sp.y = H / 2;
            }
            
            
        private function onMouseDownHandler(e:MouseEvent):void { _mode = true  }
        private function   onMouseUpHandler(e:MouseEvent):void { _mode = false }        
        //private function onMouseDownHandler(e:MouseEvent):void { _mode = false }
        //private function   onMouseUpHandler(e:MouseEvent):void { _mode = true  }        

            
        private function onEnterFrameHandler(e:Event):void  
        {

            _perspective.projectionCenter = new Point(W /2, H /2 )
             //perspective.projectionCenter = new Point( W/2,H/2 )
            _bmd.perlinNoise( 100,300,1,seed, true, _mode, 7, false, [_ox]  )
            var r:Number = Math.random();
            var g:Number = Math.random();
            var b:Number = Math.random();
            //_bmd.colorTransform( _bmd.rect,new ColorTransform( 1.00,1.00,1.00,1.00 )  )
            //_bmd.colorTransform( _bmd.rect,new ColorTransform(r, g, b)  )
            
            for(var i : uint = 0;i < N;i++)
            {
                    _bmds[i].copyPixels(_bmd, new Rectangle(0, i / N * P, 200, P / N), new Point())
            }
            _ox.x += _stepX
        }


    }
}
