/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xCv8
 */

package {
    import flash.filters.DisplacementMapFilter;
    import flash.geom.Matrix;
    import flash.text.TextField;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.ColorTransform;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    
    public class RandomTriangle extends Sprite {
        
            private const PARTICLE_NUM:Number = 50;
            private var container:Sprite;
            private var _particles    :Array;
        private var counter:Number;
        private var canvas:BitmapData;
        private var fxbmd:BitmapData;
        private var cTrs:ColorTransform;
        private var bFlt:BlurFilter;
        private var dFlt:DisplacementMapFilter;
        private var mat:Matrix;
                
            // ノイズ関数の数
        private var octaveCnt:Number = 3;
        // 乱数シード
        private var rndSeed:Number = Math.floor(Math.random() * 65535);
        // パーリンノイズのオフセット値の配列
        private var offsetArray:Array = new Array();
        // パーリンノイズの変化量の配列
        private var speedArray:Array = new Array();
        
        // 変化スピード
        private var speed:Number;
        
        // パーリンノイズ画像
        private var perlinNoiseBitmap:BitmapData;
            
            public function RandomTriangle(){
                
                _particles = [];
                
                container = new Sprite();
                addChild(container);
                
                canvas = new BitmapData(stage.stageWidth, stage.stageHeight);
                addChild(new Bitmap(canvas)) as Bitmap;
                cTrs = new ColorTransform(1, 1, 1, .8);
                bFlt = new BlurFilter(4, 4, 1);
                mat = new Matrix(.8,0,0,.8,0,0);
                
                draw(PARTICLE_NUM);
                addEventListener(Event.ENTER_FRAME, _upDate);
                
            perlinNoiseBitmap = new BitmapData(canvas.width, canvas.height);
            // 関数の数だけ必要
            for (var i:Number = 0; i < octaveCnt; i++) {
              offsetArray[i] = new Point(0, 0);
              // 乱数で変化する向きを決定
              speedArray[i] = new Point(speed * (Math.floor(Math.random() * 2) == 0 ? -1 : 1), 
                                        speed * (Math.floor(Math.random() * 2) == 0 ? -1 : 1));
            }
            // パーリンノイズ画像生成
            perlinNoiseBitmap.perlinNoise(
                canvas.width,
                canvas.height,
                octaveCnt,
                rndSeed,
                false,
                true,
                1,
                false,
                offsetArray
            );
            // 歪みフィルターを作成
            dFlt = new DisplacementMapFilter(
                perlinNoiseBitmap,
                new Point(0, 0),
                1, 1,
                -20, 20
            );
            }
            
            private function draw(num:Number):void{
                for(var i:int=0; i<num; i++){
                    _particles.push( new RandomShaper(0xff0082*i) );
                    _particles[i].x = Math.random() * stage.stageWidth;
                    _particles[i].y = stage.stageHeight/2 + Math.random()*40-20;
                    _particles[i].alpha = .5;
                    container.addChild(_particles[i]);
                }
            }
            
            private function _upDate(e:Event):void {
                for (var i:int = 0; i < _particles.length; i++ ) {
                    _particles[i].x += _particles[i].vx;
                    _particles[i].y += _particles[i].vy;
                    _particles[i].rotationX += _particles[i].vx;
                    _particles[i].rotationZ += _particles[i].vx;
                    if (_particles[i].getDeadFlag)
                    {
                        container.removeChild( _particles[i] );
                        _particles.splice(i, 1);
                        
                    }
            }
            if (_particles.length <= 0) draw(PARTICLE_NUM);
            
            // Offset
            for (var d:Number = 0; d < octaveCnt; d++) {
                offsetArray[d].x += speedArray[d].x;
                offsetArray[d].y += speedArray[d].y;
            }
            
            canvas.lock();
            canvas.draw(container);
            canvas.colorTransform(canvas.rect, cTrs);
            canvas.applyFilter(canvas, canvas.rect, new Point(0,0), dFlt);
            canvas.unlock();
            }
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.events.TimerEvent;
import flash.utils.Timer;

class RandomShaper extends Sprite {
    public var sc    :Sprite;
    public var col    :uint;
    public var life:Number;
    public var vx:Number;
    public var vy:Number;
    
    private var death:Number;
    private var deadFlag:Boolean;
    private var s    :Sprite;
    private var t    :Timer;
            
    public function RandomShaper(color:uint) {
        deadFlag = false;
        
        if (!color) col = 0x0;
        else col = color;
        
        life = 0;
        death = Math.random()*30+10;
        
        vx = Math.random() * 6 - 3;
        vy = Math.random() * 6 - 3;
        
        //中心点を移動させる用のコンテナ
        sc = new Sprite();
        addChild(sc);
        sc.rotationX = Math.random() * 180;
        sc.rotationY = Math.random() * 180;
        sc.rotationZ = Math.random() * 180;
            
        //本体
        s = new Sprite();
        sc.addChild(s);
            
        t = new Timer(100);
        t.start();
            
        //ランダムな三角形
        t.addEventListener(TimerEvent.TIMER, _upDate);
            
        //TimerのDelay弄くる用
        sc.addEventListener(Event.ENTER_FRAME, _timerSet);
    }
        
    private function draw():void
    {
        //ドローするぜよ
        s.graphics.clear();
        s.graphics.beginFill(col);
        s.graphics.moveTo(0, 0);
        s.graphics.lineTo(Math.random() * 100, Math.random() * 400);
        s.graphics.lineTo(Math.random() * 60-30, Math.random() * 400-200);
        s.graphics.endFill();
        s.x = -s.width / 2;
        s.y = -s.height / 2;
    }
        
    private function _timerSet(e:Event):void{
        life++;
        if(life>death) kill();
        
        //Delayをめちゃくちゃにする
        t.delay = Math.random() * 80;
    }
        
    private function _upDate(e:Event):void{
        draw();

        //ぐるんぐるん回す
    }
    
    private function kill():void{
        t.removeEventListener(TimerEvent.TIMER, _upDate);
        sc.removeEventListener(Event.ENTER_FRAME, _timerSet);
        t.stop();
        sc.removeChild(s);
        removeChild(sc);
        deadFlag = true;
    }
    
    public function get getDeadFlag():Boolean{
        return deadFlag;
    }
}