/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xCol
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.utils.ByteArray;
    
    [SWF(width = 465, height = 465)]
    public class Main extends Sprite
    {
        private var snd:Sound;
        private var sndChannel:SoundChannel;
        
        private var _container:Sprite;
        private var _bitmap:Bitmap;
        private var _bitmapdata:BitmapData;
        private var _len:Number;
        
        public function Main():void 
        {
            graphics.beginFill(0);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            _len = Math.round(Math.sqrt(465 * 465 + 465 * 465));
            
            _container = new Sprite();
            _container.x = stage.stageWidth / 2;
            _container.y = stage.stageHeight / 2;
            addChild(_container);
            
            _bitmapdata = new BitmapData(_len, _len, false, 0xFF000000);
            
            _bitmap = new Bitmap(_bitmapdata);
            _bitmap.x = -(_len / 2);
            _bitmap.y = -(_len / 2);
            _container.addChild(_bitmap);
            
            Security.allowDomain("takasumi-nagai.com");
            
            playSound("http://www.takasumi-nagai.com/soundfiles/sound003.mp3");
        }
        
        private function playSound(sndUrl:String):void
        {
            snd = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(10,true);
            var req:URLRequest = new URLRequest(sndUrl);
            snd.load(req, context);
            snd.addEventListener(Event.COMPLETE, onComp);
        }0
        
        private function onComp(e:Event):void 
        {
            sndChannel=new SoundChannel();
            sndChannel = snd.play(0, 10, new SoundTransform(0.5, 0));
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(event:Event):void 
        {
            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes, false, 0);
            bytes.position = 0;
            
            
            
            var _temp:BitmapData = new BitmapData(_len, _len, false, 0xFF000000);
            
            _temp.lock();
            for (var i:int = 0; i < 512; i++)
            {
                var data:Number = bytes.readFloat();
                
                var p:Number = data * 1000000;
                
                var _x:Number = Math.random() * _len;
                var _y:Number = Math.random() * _len;
                
                if (p < 0x00FFFF) {
                    p = 0;
                }else {
                    p = 0xFFFFFF;
                    _temp.setPixel(_x, _y, p);
                    _temp.setPixel(_x + 1, _y, p);
                    _temp.setPixel(_x + 2, _y, p);
                    _temp.setPixel(_x + 3, _y, p);
                    _temp.setPixel(_x + 4, _y, p);
                    _temp.setPixel(_x + 5, _y, p);
                    _temp.setPixel(_x + 4, _y + 1, p);
                    _temp.setPixel(_x + 4, _y - 1, p);
                    _temp.setPixel(_x + 3, _y + 2, p);
                    _temp.setPixel(_x + 3, _y - 2, p);
                }
               
            }
            _temp.unlock();
            _bitmapdata.draw(_temp);
            
            var _bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(_bytes, true, 0);
            _bytes.position = 0;
            
            var _data:Number = 0;
            
            for (var j:int = 0; j < 512; j++ )
            {
                _data += _bytes.readFloat();
            }
            
            if (_data > 36)
            {
                _container.rotation += ((_container.rotation + 45) - _container.rotation) * 0.2;
            }
            
        }
    }
}