/**
 * Copyright janselike ( http://wonderfl.net/user/janselike )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xCir
 */

package {

    import flash.display.Sprite;
    import flash.events.Event;

    [SWF(backgroundColor=0x000000,frameRate=25,width=320,height=480)]

    public class Fire extends Sprite {
        
        private var numbers:int = 0;
        private var collection:Vector.<FireParticle> = new Vector.<FireParticle>();
        //
        private var gravity:Number = 9.81;

        public function Fire():void {
            stage.addEventListener(Event.ENTER_FRAME, init);
        }

        private function iterate():void {
            for each(var item:FireParticle in this.collection ) {
                item.y += item.velocity;
                if (item.y > 480) {
                    this.collection.splice(this.collection.indexOf(item), 1);
                    this.removeChild(item);
                }
                item.velocity += 1 * Math.random();
            }
        }

        private function init(e:Event):void {
            this.addParticles();
            this.numbers++;
            this.iterate();
        }

        private function addParticles():void {
            for (var i:int = 0; i < 25; i++) {
                var tmp:FireParticle = new FireParticle('square');
                tmp.x = 150 * Math.random();
                tmp.y = 19 * Math.random();
                this.addChild(tmp);
                
                this.collection.push(tmp);
            }
            
        }
    }
}

    import flash.display.Sprite;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.GlowFilter;

     class FireParticle extends Sprite {

        public var velocity:Number = 0;
        private var kind:String = 'square';

        public function FireParticle(kind:String = 'square'):void {
            this.kind = kind;
            this.init();

        }

        private function init():void {
            this.graphics.lineStyle(1, 0xfcfe15);
            this.graphics.beginFill(0xfcfe15);

            if (this.kind == 'square') {
                this.graphics.moveTo(0,0);
                this.graphics.lineTo(0, 3);
                this.graphics.lineTo(3, 3);
                this.graphics.lineTo(3, 0);
            }
            else {
                this.graphics.drawCircle(0, 0, 2);
            }
            

            var glow:GlowFilter = new GlowFilter(); 
            glow.color = 0xfcfe15; 
            glow.alpha = 0.8; 
            glow.blurX = 7; 
            glow.blurY = 7; 
            glow.quality = BitmapFilterQuality.LOW;
            
            this.filters = [glow];
        }
    }