/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xBsY
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import caurina.transitions.Tweener;
    import caurina.transitions.properties.CurveModifiers;
    import frocessing.color.ColorHSV;
    
    [SWF(width=465, height=465, frameRate=30, backgroundColor=0xFFFFFF)]
    
    public class FlashTest extends Sprite {
        private var _isMouseDown:Boolean = false;
        private var _hsv:ColorHSV;
        private var _txt:TextField;
        
        public function FlashTest() {
             CurveModifiers.init();
             _hsv = new ColorHSV(0, 1, 1, 1);
             _txt = new TextField();
             _txt.defaultTextFormat = new TextFormat("Verdana", 48);
             _txt.autoSize = TextFieldAutoSize.LEFT;
             
             stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
             stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
             stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);                     
        }
        
        private function enterFrameHandler(evt:Event):void
        {
            _hsv.h = ++_hsv.h % 360;
            
            if(!_isMouseDown) return;
            
            _txt.text = String.fromCharCode(getCharCode());
            _txt.textColor = _hsv.value;
            
            var bmd:BitmapData = new BitmapData(_txt.width, _txt.height, true, 0);
            
            bmd.draw(_txt);
            
            var bm:Bitmap = new Bitmap(bmd, "auto", true);
            bm.x -= bm.width / 2;
            bm.y -= bm.height / 2;
            
            var sp:Sprite = new Sprite();
            sp.addChild(bm);
            sp.x = mouseX;
            sp.y = mouseY;
            
            addChild(sp);
            
            var endX:Number = Math.random() * stage.stageWidth;
            var ctlX:Number = mouseX + (endX - mouseX) / 2;
            
            Tweener.addTween(sp,{
                x:endX,
                y:stage.stageHeight,
                rotation: Math.random() * 360,
                alpha:0,
                _bezier:[{x:ctlX, y:0}],
                time:1,
                transition: "linear",
                onComplete: onTweenComplete,
                onCompleteParams: [sp]
            });
        }
        
        private function getCharCode():int
        {
            var ret:int = 0;
            
            switch(int(Math.random() * 3))
            {
                case 0:
                ret=int(48+Math.random()*10);
                break;
                
                case 1:
                ret = int(65 + Math.random() * 26);
                break;
                
                case 2:
                ret = int(97 + Math.random() * 26);
                break;
                
                default:
                ret = 48;
            }
            return ret;
        }
        
        private function onTweenComplete(sp:Sprite):void
        {
            removeChild(sp);
        }
        
        private function mouseDownHandler(evt:MouseEvent):void
        {
            _isMouseDown = true;
        }
        
        private function mouseUpHandler(evt:MouseEvent):void
        {
            _isMouseDown = false;
        }






    }
}