/**
 * Copyright taka_milk ( http://wonderfl.net/user/taka_milk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xAnb
 */

// forked from matsumos's flash on 2010-1-5
/* 
 * 1. 画像の上を適当にドラッグして色を塗る
 * 2. 左上 Blur ボタンをクリックすればなめらか
 * 3. 満足いくまで塗ったら、左下 Make3D ボタンをクリック
 * 4. 画像をドラッグして回転したり、下の Height スライダを動かすなど
 */

package
{
	import com.bit101.components.*;
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	import flash.geom.*;
	import flash.net.*;
	import flash.system.LoaderContext;
	import flash.system.Security;
	import org.papervision3d.cameras.*;
	import org.papervision3d.core.math.*;
	import org.papervision3d.materials.*
	import org.papervision3d.objects.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.*;

	public class Main extends BasicView
	{
		private var _plane:Plane;
		private var _material:BitmapMaterial;
		private var _paint:Paint;
		private var _canvas:BitmapData;
		private var _imageWidth:int;
		private var _imageHeight:int;
		private var _make3dButton:PushButton;
		private var _draw2dButton:PushButton;
		private var _hitArea:Sprite;
		private var _heightSlider:HUISlider
		
		public function Main():void
		{
			super( 465, 465, true, false, CameraType.TARGET );
						
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener( Event.COMPLETE, function():void { 
				_material = new BitmapMaterial( Bitmap( loader.content ).bitmapData );
				var rate:Number = loader.content.width / loader.content.height;
				
				if ( rate > 1 ) {
					_imageWidth = loader.width = 465;
					_imageHeight = loader.height * loader.scaleX;
				}
				else if ( rate < 1 ) {
					_imageHeight = loader.height = 465;
					_imageWidth = loader.width * loader.scaleY;
				}
				else if ( rate == 1 ) {
					_imageWidth = 465;
					_imageHeight = 465;
				}
				
				loader.unload();
				loadComplete();
			} );
			
			loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/7/78/7819/781939489515eb746625f701e5ee4731f69f0fbd"), new LoaderContext(true));
		}
		
		private function loadComplete():void
		{
			
			_canvas = new BitmapData( _imageWidth, _imageHeight, true, 0x00000000 );
			
			_paint = new Paint( _canvas, _imageWidth, _imageHeight );			
			addChild(_paint);
			_paint.init();
			
			_material.doubleSided = true;

			_plane = new Plane( _material, _imageWidth, _imageHeight, Math.floor( _imageWidth/10 ), Math.floor( _imageHeight/10 ) );
			scene.addChild( _plane );
			
			var targetPos:DisplayObject3D = new DisplayObject3D();
			targetPos.copyTransform( _plane );
			targetPos.moveBackward( camera.focus * camera.zoom * this.scaleX );

			camera.x = targetPos.x;
			camera.y = targetPos.y;
			camera.z = targetPos.z;

			var matrix:Matrix = new Matrix();
			matrix.createGradientBox( _imageWidth, _imageHeight, 45 * Math.PI / 180 );

			_draw2dButton = new PushButton( this, 0, stage.stageHeight - 20, "Draw2D", draw2d );
			_make3dButton = new PushButton( this, 0, stage.stageHeight - 20, "Make3D", make3d );
			
			_heightSlider = new HUISlider( this, stage.stageHeight / 2, stage.stageHeight - 20, "Height", heightSlideHandler );
			_heightSlider.value = 20;
			pheight = .2;
			
			_hitArea = new Sprite();
			_hitArea.graphics.beginFill( 0x0, 0 );
			_hitArea.graphics.drawRect( 0, 0, stage.stageWidth,stage.stageHeight );
			_hitArea.graphics.endFill();
			addChildAt(_hitArea, getChildIndex(viewport) + 1);
			
			startRendering();
			
			draw2d();
		}
		
		private var pheight:Number = 0;
		private var pointArray:Array = [];
		
		private function heightSlideHandler( e:Event ):void
		{
			pheight = e.target.value / 100;
			updateVertices();
		}
		
		private function updateVertices():void
		{
			for ( var i:int = 0; i < pointArray.length; i++ ) 
			{
				_plane.geometry.vertices[i].z = pointArray[i] * pheight;
			}
		}
		
		private var _lastRotationX:Number = 0;
		private var _lastRotationY:Number = 0;
		
		private function draw2d( e:Event = null ):void
		{
			addChild(_paint);
			_make3dButton.visible = true;
			_draw2dButton.visible = false;
			_heightSlider.visible = false;
			
			for ( var i:int = 0; i < pointArray.length; i++ ) 
			{
				_plane.geometry.vertices[i].z = 0;
			}
			
			_lastRotationX = _plane.rotationX;
			_lastRotationY = _plane.rotationY;
			
			_plane.rotationX = 0;
			_plane.rotationY = 0;
			
			_hitArea.removeEventListener( MouseEvent.MOUSE_DOWN, mouseDownHandler );
		}
		
		private function make3d( e:Event ):void
		{
			_plane.rotationX = _lastRotationX;
			_plane.rotationY = _lastRotationY;
			
			removeChild( _paint );
			_make3dButton.visible = false;
			_draw2dButton.visible = true;
			_heightSlider.visible = true;
			
			var pcanvas:BitmapData = new BitmapData( _imageWidth, _imageHeight, false, 0x000000 );
			pcanvas.draw( _canvas );
			
			var s:int = 0;
			
			for ( var i:int = 0; i <= _plane.segmentsW; i++ ) 
			{
				for ( var j:int = _plane.segmentsH; j >= 0; j-- ) 
				{
					var xp:int = _imageWidth * ( i / _plane.segmentsW );
					xp = xp < _imageWidth ? xp : _imageWidth -1;
					var yp:int = _imageHeight * ( j / _plane.segmentsH );
					yp = yp < _imageHeight ? yp : _imageHeight -1;
					pointArray[s] = - pcanvas.getPixel( xp, yp ) / 100000;
					//_plane.geometry.vertices[s].z = -pcanvas.getPixel(xp, yp) / 200000;
					s++;
				}
			}
			
			updateVertices();
			
			_hitArea.addEventListener( MouseEvent.MOUSE_DOWN, mouseDownHandler );
			stage.addEventListener( MouseEvent.MOUSE_UP, mouseUpHandler );
		}
		
		private function mouseDownHandler( e:Event ):void
		{	
			curX = mouseX;
			curY = mouseY;
			addEventListener( MouseEvent.MOUSE_MOVE, mouseMoveHandler );
		}
		
		private function mouseUpHandler( e:MouseEvent ):void
		{
			removeEventListener( MouseEvent.MOUSE_MOVE, mouseMoveHandler );
		}
		
		private var curX:Number = 0;
		private var curY:Number = 0;
		
		private function mouseMoveHandler( e:MouseEvent ):void 
		{
			_plane.rotationY += ( curX - mouseX );
			_plane.rotationX -= ( curY - mouseY );
			
			curX = mouseX;
			curY = mouseY;
		}
	}
}





import com.bit101.components.*;
import flash.display.*;
import flash.events.*;
import flash.filters.*;
import flash.geom.*;

class Paint extends Sprite
{
	
	private var _brush:Brush;
	private var _drawField:Sprite;
	private var _background:Bitmap;
	private var _canvas:BitmapData;
	private var _imageHeight:Number;
	private var _imageWidth:Number;
	private var _blurButton:PushButton;
	
	public function Paint( canvas:BitmapData, imageWidth:Number, imageHeight:Number )
	{
		_canvas = canvas;
		_imageWidth = imageWidth;
		_imageHeight = imageHeight;
	}

	public function init():void
	{
		
		var hitArea:Sprite = new Sprite();
		hitArea.graphics.beginFill( 0x0, 0 );
		hitArea.graphics.drawRect( 0, 0, _imageWidth, _imageHeight );
		hitArea.graphics.endFill();
		addChild( hitArea );
		hitArea.addEventListener( MouseEvent.MOUSE_DOWN, mouseDownHandler );
		stage.addEventListener( MouseEvent.MOUSE_UP, mouseUpHandler );
		
		this.x = stage.stageWidth - _imageWidth >> 1;
		this.y = stage.stageHeight - _imageHeight >> 1;
		
		_brush = new Brush( 25, 0xFF0000, .5 );
		
		_drawField = new Sprite();
		addChild( _drawField );
		
		var bitmap:Bitmap = new Bitmap(_canvas);
		addChild(bitmap)
		
		_blurButton = new PushButton( this, 0, 0, "Blur", blurBitmapData );
		
		var thicknessSlider:HUISlider = new HUISlider( this, 0, 30, "Thickness", thicknessSliderHandler );
		thicknessSlider.value = 25;
		
		var alphaSlider:HUISlider = new HUISlider( this, 0, 50, "Alpha", alphaSlider );
		alphaSlider.value = 50;
	}
	
	private function alphaSlider( e:Event ):void
	{
		_brush.alpha = e.target.value/100;
	}
	
	private function thicknessSliderHandler( e:Event ):void
	{
		_brush.thickness = e.target.value;
	}
	
	private function blurBitmapData( e:Event ):void
	{
		_canvas.applyFilter(_canvas, _canvas.rect, new Point, new BlurFilter( 32, 32, 4 ));
	}
	
	private function mouseDownHandler( e:MouseEvent ):void
	{
		_drawField.graphics.lineStyle( _brush.thickness, _brush.color, _brush.alpha );
		_drawField.graphics.moveTo( mouseX, mouseY );
		_drawField.addEventListener( Event.ENTER_FRAME, drawingHandler );
	}
	
	private function mouseUpHandler( e:MouseEvent ):void
	{
		_drawField.graphics.endFill();
		_canvas.draw( _drawField );
		_drawField.graphics.clear();
		_drawField.removeEventListener( Event.ENTER_FRAME, drawingHandler );
	}
	
	private function drawingHandler( e:Event ):void
	{
		_drawField.graphics.lineTo( mouseX, mouseY );
	}
	
}





class Brush 
{
	public var thickness:uint = 1;
	public var color:uint = 0x000000;
	public var alpha:Number = alpha;
	
	public function Brush( thickness:uint = 10, color:uint = 0xFF0000, alpha:Number = 1 )
	{
		this.thickness = thickness;
		this.color = color;
		this.alpha = alpha;
	}
	
}

