/**
 * Copyright aruerula ( http://wonderfl.net/user/aruerula )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xALD
 */

// forked from siouxcitizen's Bitmap練習01：複数の画像を読み込み練習
// forked from siouxcitizen's Bitmapデータを読み込んで複数3DPlaneオブジェクトに貼り付ける練習
//
//複数の画像を読み込み練習
//
//そもそもBitmapの理解がなってないっぽいので基本的なことから練習中です
//
//↓以下サイトを参考にさせていただきました
//ActionScript入門Wiki@rsakane　複数の画像を読み込む(基本編)
//http://www40.atwiki.jp/spellbound/pages/310.html
//
package
{
    import flash.events.MouseEvent;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.system.Security;
 
    public class Main extends Sprite
    {
        private var count:int = 0;    // 読み込んだ画像数
        private var images:Array;    // 読み込んだ画像
 
        private    const IMAGE_URL:Array =
        [
            "http://assets.wonderfl.net/images/related_images/1/19/19c0/19c0967e02f10579880511d29d725a4a9f983f1a",
            "http://assets.wonderfl.net/images/related_images/e/e1/e12b/e12b4d301954b19d91c96df4bbf2eaf5fc82f726",
            "http://assets.wonderfl.net/images/related_images/7/7b/7be2/7be290bce731b60e8bceffb7f1bee308b342ad28"
        ];
 
        public function Main()
        {
            images = new Array(IMAGE_URL.length);
 
            for (var i:int = 0; i < IMAGE_URL.length; i++)
            {
                var loader:Loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
                loader.load(new URLRequest(IMAGE_URL[i]), new LoaderContext(true));
                loader.name = i.toString();
            }
        }
 
        private function onComplete(event:Event):void
        {
            images[event.currentTarget.loader.name] = event.currentTarget.loader;
            if (++count == IMAGE_URL.length) display();
        }
 
        private function display():void
        {
            for (var i:int = 0; i < images.length; i++)
            {
                for (var j:int = 0; j< images.length; j++)
                {
                    images[i].x = 465 / images.length * i;
                    images[i].y = 200 / images.length * j;
                    addChild(images[i]);
                }
            }
        }
    }
}
 