/**
 * Copyright takimo ( http://wonderfl.net/user/takimo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xA6G
 */

package {
    import flash.text.engine.TextLine;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFieldType;
    import flash.display.Sprite;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.IOErrorEvent;
    import flash.events.SecurityErrorEvent;
    
    public class FlashTest extends Sprite {
        private var _loader:URLLoader;
        private var _log:TextField = new TextField();
        private var _input:TextField = new TextField();
        private var _submit:Sprite = new Sprite();
        
        public function FlashTest() {
            init();
        }
        
        private function init():void{
            _log.x = 10;
            _log.y = 70;
            _log.autoSize = TextFieldAutoSize.LEFT;
           
            _input.x = _input.y = 10;
            _input.border = true;
            _input.text = "http://";
            _input.width = 400;
            _input.height = 20;
            _input.type = TextFieldType.INPUT
            
            _submit.buttonMode = true;
            _submit.graphics.clear();
            _submit.graphics.beginFill(0xD4D4D4); 
            _submit.graphics.drawRoundRect(0, 0, 60, 22, 10, 10);
            _submit.x = 10;
            _submit.y = 40;
            _submit.addEventListener(MouseEvent.CLICK, clickSubmitHandler);
             
            addChild(_log); 
            addChild(_input);
            addChild(_submit);
        }

        private function getContent():void{
            if(!_input.text) return;
            if(_loader) _loader.close();
            var request:URLRequest = new URLRequest(_input.text);
            _loader = new URLLoader();
            _loader.addEventListener(IOErrorEvent.IO_ERROR, errorHandler);
            _loader.addEventListener(Event.COMPLETE, loaderCompleteHandler);
            try{
                _loader.load(request);
                _log.text = "load...";
            }catch(e:SecurityErrorEvent){
                _log.text = "security error";
            }
        }
        
        private function errorHandler(e:IOErrorEvent):void{
            _log.text = "error";
        }
        
        private function loaderCompleteHandler(e:Event):void{
            _log.text = _loader.data;
        }
        
        private function clickSubmitHandler(e:MouseEvent):void{
            getContent();
        }

    }
}