/**
 * Copyright paq ( http://wonderfl.net/user/paq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x9xf
 */

package
{
    import flash.text.TextFormat;
    import flash.text.TextField;
    import com.adobe.serialization.json.JSON;
    import com.bit101.components.InputText;
    import com.bit101.components.PushButton;
    import com.bit101.components.Style;
    import com.bit101.components.Label;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import net.wonderfl.utils.FontLoader;
    
    /**
     *
     * @author paq89
     */
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]
    public class TweetToSpeech extends Sprite
    {
        private const FONT_NAME:String = "Aqua";
        
        private var _queue:StringQueue;
        private var _speaker:Speaker;
        
        private var _request:URLRequest;
        private var _loader:URLLoader;
        private var _input:InputText;
        private var _tweet:TextField;
        private var _searchButton:PushButton;
        
        public function TweetToSpeech()
        {
            WonderflTemplate.init(this, init);
        }
        
        private function init():void
        {
            // 変数の初期化
            _queue = new StringQueue();
            _speaker = new Speaker(_queue);
            _request = new URLRequest();
            _loader = new URLLoader();
            
            var fontLoader:FontLoader = new FontLoader();
            fontLoader.addEventListener(Event.COMPLETE, _onFontLoadComplete);
            fontLoader.load(FONT_NAME);
        }
        
        private function _onFontLoadComplete(event:Event):void
        {
            _createUI();
            
            _loader.addEventListener(Event.COMPLETE, _onLoadComplete);
            addEventListener(Event.ENTER_FRAME, _onEnterFrame);
        }
        
        private function _createUI():void
        {
            Style.fontName = FONT_NAME;
            Style.fontSize = 12;
            Style.BACKGROUND =Style.LABEL_TEXT =  0xFFFFFF;
            Style.BUTTON_FACE = Style.INPUT_TEXT = 0x000000;
            
            _input = new InputText(this, 0, 0, "flash 落ち");
            _searchButton = new PushButton(this, 0, 0, "SEARCH", function():void {
                if (_input.text == "") return;
                _queue.clear();
                _search(_input.text);
                _tweet.text = _input.text = "";
            });
            
            _input.setSize(200, 20);
            _input.move(stage.stageWidth / 2 - _input.width / 2 - 25, 100);
            _searchButton.setSize(50, _input.height);
            _searchButton.move(_input.x + _input.width, _input.y);
            
            var tf:TextFormat = new TextFormat();
            tf.font = FONT_NAME;
            tf.align = "center";
            _tweet = new TextField();
            _tweet.embedFonts = true;
            _tweet.wordWrap = true;
            _tweet.defaultTextFormat = tf;
            _tweet.x = stage.stageWidth / 2 - 200;
            _tweet.y = stage.stageHeight / 2;
            _tweet.width = 400;
            _tweet.height = 40;
            addChild(_tweet);
        }
        
        private function _search(str:String):void
        {
            _request.url = "http://search.twitter.com/search.json?q=" + encodeURIComponent(str.replace(" ", "+"));
            _loader.load(_request);
        }
        
        private function _onEnterFrame(event:Event):void
        {
            _speaker.step();
            if (_speaker.job && _tweet.text != _speaker.job)
            {
                _tweet.text = _speaker.job;
            }
        }
        
        private function _onLoadComplete(event:Event):void
        {
            var json:Object = JSON.decode(event.target.data);
            for each (var tweet:Object in json.results)
            {
                var str:String = tweet.text || "";
                str = str.replace( /https?:\/\/[-_.!~*'()\w;\/?:@&=+$,%#]+/gi, "")
                         .replace(/@[\w]+\s/gi, "")
                         .replace(/RT\s.+$/gi, "")
                         .replace(/^\s+/i, "")
                         .replace("\n", "")
                         .replace("Flasher", "フラッシャー")
                         .substr(0, 100);
                if (str != "")
                {
                    trace(str)
                    _queue.push(str)
                }
            }
        }
    }
    
}

//----------------------------------------------------------------------------

import flash.display.DisplayObjectContainer;
import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Stage;
import flash.display.StageAlign;
import flash.display.StageScaleMode;
import flash.events.Event;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.net.URLRequest;
import flash.net.URLVariables;

//----------------------------------------------------------------------------

internal class StringQueue extends Object
{
    private var _queue:Vector.<String>;
    public function StringQueue() { _queue = new Vector.<String>(); }
    public function checkPoll():Boolean { return _queue.length > 0; }
    public function isEmpty():Boolean { return _queue.length == 0; }
    public function poll():String { return _queue.shift(); }
    public function push(str:String):void { _queue.push(str) }
    public function clear():void { _queue.length = 0; }
}

//----------------------------------------------------------------------------

internal class Speaker extends Object
{
    private var _isPlaying:Boolean;
    public function get isPlaying():Boolean { return _isPlaying; }
    
    private var _job:String;
    public function get job():String { return _job; }
    
    private var _queue:StringQueue;
    public function get queue():StringQueue { return _queue; }
    
    private var _request:URLRequest;
    private var _variables:URLVariables;
    
    private var _sound:Sound;
    private var _soundChannel:SoundChannel;
    
    public function Speaker(queue:StringQueue)
    {
        _queue = queue;
        _request = new URLRequest("http://wonder-tools.appspot.com/api/tts");
        _variables = new URLVariables();
        _request.data = _variables;
    }
    
    public function step():void
    {
        if (!_isPlaying && _queue.checkPoll())
        {
            _job = _variables.q = _queue.poll();
            _variables.tl = "ja";
            _isPlaying = true;
            _sound = new Sound();
            _sound.addEventListener(Event.COMPLETE, _onSoundLoadComplete);
            _sound.load(_request);
        }
    }
    
    private function _onSoundLoadComplete(event:Event):void
    {
        _soundChannel = _sound.play();
        _soundChannel.addEventListener(Event.SOUND_COMPLETE, _onSoundComplete);
    }
    
    private function _onSoundComplete(event:Event):void
    {
        _soundChannel.removeEventListener(Event.SOUND_COMPLETE, _onSoundComplete);
        _sound.removeEventListener(Event.SOUND_COMPLETE, _onSoundComplete);
        
        _isPlaying = false;
        
        _soundChannel = null;
        _sound = null;
    }
}

//----------------------------------------------------------------------------

internal class WonderflTemplate extends Object
{
    private static var _stage:Stage;
    private static var _target:DisplayObjectContainer;
    private static var _handler:Function;
    private static var _frameRate:int;
    private static var _background:Shape;
    private static var _backgroundColor:uint;
    
    public static function init(target:DisplayObjectContainer, handler:Function, backgroundColor:uint=0xFFFFFF, frameRate:int = 60):void
    {
        _target = target;
        _handler = handler;
        _frameRate = frameRate;
        _backgroundColor = backgroundColor;
        
        Wonderfl.capture_delay(10);
        
        _target.addEventListener(Event.ADDED_TO_STAGE, _onAddToStage);
    }
    
    private static function _onAddToStage(event:Event):void
    {
        _target.removeEventListener(Event.ADDED_TO_STAGE, _onAddToStage);
        
        // Stage
        _stage = _target.stage
        _stage.align = StageAlign.TOP_LEFT;
        _stage.scaleMode = StageScaleMode.NO_SCALE;
        _stage.frameRate = _frameRate;
        _stage.addEventListener(Event.RESIZE, _onResize);
        
        // Background
        _background = new Shape();
        _target.addChildAt(_background, 0);
        _onResize();
        
        _handler();
    }
    
    private static function _onResize(event:Event = null):void
    {
        // Background drawing
        var g:Graphics = _background.graphics;
        g.clear();
        g.beginFill(_backgroundColor);
        g.drawRect(0, 0, _stage.stageWidth, _stage.stageHeight);
    }
}